/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.commands.GreatCommands;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class GCUtilCommand
implements CommandExecutor {
    private final GreatCrafts plugin;

    public GCUtilCommand(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subcommand = GreatCommands.argumentString(0, args);
        if (subcommand == null) {
            return false;
        }
        if (subcommand.equalsIgnoreCase("setcustomname")) {
            String name = GreatCommands.argumentStringConsumeRest(1, args);
            if (name == null) {
                sender.sendMessage("\u00a7c/greatcraftsutil setcustomname <name... (use & for colors)>");
                return true;
            }
            if (!(sender instanceof Player)) {
                this.plugin.languager.commandErrorPlayerRequired(sender);
                return true;
            }
            Player player = (Player)sender;
            this.setCustomName(player, name);
            return true;
        }
        if (subcommand.equalsIgnoreCase("setloreline")) {
            Integer lineNum = GreatCommands.argumentInteger(1, args);
            String loreLine = GreatCommands.argumentStringConsumeRest(2, args);
            if (loreLine == null) {
                loreLine = "";
            }
            if (lineNum == null) {
                sender.sendMessage("\u00a7c/greatcraftsutil setloreline <line # (starts from 0)> [<lore line... (use & for colors)>]");
                return true;
            }
            if (!(sender instanceof Player)) {
                this.plugin.languager.commandErrorPlayerRequired(sender);
                return true;
            }
            Player player = (Player)sender;
            this.setLoreLine(player, lineNum, loreLine);
            return true;
        }
        if (subcommand.equalsIgnoreCase("deletelorelines")) {
            int[] lineNums = GreatCommands.argumentIntegerConsumeRest(1, args);
            if (lineNums == null) {
                sender.sendMessage("\u00a7c/greatcraftsutil deletelorelines <line # (starts from 0)> [<line #> <line #> ...]");
                return true;
            }
            if (!(sender instanceof Player)) {
                this.plugin.languager.commandErrorPlayerRequired(sender);
                return true;
            }
            Player player = (Player)sender;
            this.deleteLoreLines(player, lineNums);
            return true;
        }
        if (subcommand.equalsIgnoreCase("enchant")) {
            Enchantment enchant = GreatCommands.argumentMinecraftEnchantment(1, args);
            Integer level = GreatCommands.argumentInteger(2, args);
            if (enchant == null || level == null) {
                sender.sendMessage("\u00a7c/greatcraftsutil enchant <enchantment (Minecraft ID)> <level (0 to remove)>");
                return true;
            }
            if (!(sender instanceof Player)) {
                this.plugin.languager.commandErrorPlayerRequired(sender);
                return true;
            }
            Player player = (Player)sender;
            this.enchant(player, enchant, level);
            return true;
        }
        if (subcommand.equalsIgnoreCase("duplicaterecipe")) {
            String sourceRecKey = GreatCommands.argumentString(1, args);
            String targetRecKey = GreatCommands.argumentString(2, args);
            if (sourceRecKey == null || targetRecKey == null) {
                sender.sendMessage("\u00a7c/greatcraftsutil duplicaterecipe <source namespace:name> <target namespace:name>");
                return true;
            }
            this.duplicateRecipe(sender, sourceRecKey, targetRecKey);
            return true;
        }
        if (subcommand.equalsIgnoreCase("resetlimits")) {
            String targetPlayerName = GreatCommands.argumentString(1, args);
            this.resetLimits(sender, targetPlayerName);
            return true;
        }
        return false;
    }

    private void setCustomName(Player player, String name) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        ItemMeta im = handItem.getItemMeta();
        if (im == null) {
            this.plugin.languager.commandErrorNoItemMeta((CommandSender)player);
            return;
        }
        im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        handItem.setItemMeta(im);
        this.plugin.languager.commandCustomNameSuccess((CommandSender)player);
    }

    private void setLoreLine(Player player, int lineNum, String loreLine) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        ItemMeta im = handItem.getItemMeta();
        if (im == null) {
            this.plugin.languager.commandErrorNoItemMeta((CommandSender)player);
            return;
        }
        ArrayList<String> lore = im.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        if (lore.size() <= lineNum) {
            if (lore.size() + 10 <= lineNum) {
                this.plugin.languager.commandErrorLoreLineTooBig((CommandSender)player, lore.size());
                return;
            }
            for (int i = lore.size(); i <= lineNum; ++i) {
                lore.add("");
            }
        }
        lore.set(lineNum, ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine));
        im.setLore(lore);
        handItem.setItemMeta(im);
        this.plugin.languager.commandLoreLineSuccess((CommandSender)player);
    }

    private void deleteLoreLines(Player player, int[] lineNums) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        ItemMeta im = handItem.getItemMeta();
        if (im == null) {
            this.plugin.languager.commandErrorNoItemMeta((CommandSender)player);
            return;
        }
        List lore = im.getLore();
        if (lore == null) {
            this.plugin.languager.commandErrorNoLoreToDelete((CommandSender)player);
            return;
        }
        lineNums = Arrays.stream(lineNums).distinct().sorted().toArray();
        for (int i = lineNums.length - 1; i >= 0; --i) {
            int lineNum = lineNums[i];
            if (lineNum < 0 || lineNum >= lore.size()) continue;
            lore.remove(lineNum);
        }
        im.setLore(lore);
        handItem.setItemMeta(im);
        this.plugin.languager.commandLoreDeleteSuccess((CommandSender)player);
    }

    private void enchant(Player player, Enchantment enchant, int level) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta im = (EnchantmentStorageMeta)handItem.getItemMeta();
            if (level <= 0) {
                im.removeStoredEnchant(enchant);
                handItem.setItemMeta((ItemMeta)im);
                this.plugin.languager.commandRemoveEnchantSuccess((CommandSender)player);
            } else {
                im.addStoredEnchant(enchant, level, true);
                handItem.setItemMeta((ItemMeta)im);
                this.plugin.languager.commandAddEnchantSuccess((CommandSender)player);
            }
        } else {
            ItemMeta im = handItem.getItemMeta();
            if (im == null) {
                this.plugin.languager.commandErrorNoItemMeta((CommandSender)player);
                return;
            }
            if (level <= 0) {
                im.removeEnchant(enchant);
                handItem.setItemMeta(im);
                this.plugin.languager.commandRemoveEnchantSuccess((CommandSender)player);
            } else {
                im.addEnchant(enchant, level, true);
                handItem.setItemMeta(im);
                this.plugin.languager.commandAddEnchantSuccess((CommandSender)player);
            }
        }
    }

    private void duplicateRecipe(CommandSender sender, String sourceRecKey, String targetRecKey) {
        if (sourceRecKey.split(":").length != 2 || targetRecKey.split(":").length != 2) {
            this.plugin.languager.commandErrorRecipeKeyFormat(sender);
            return;
        }
        SavedRecipe rec = this.plugin.recipeManager.getRecipe(sourceRecKey);
        if (rec == null) {
            this.plugin.languager.commandErrorRecipeNotExist(sender, sourceRecKey);
            return;
        }
        if (this.plugin.recipeManager.getRecipe(targetRecKey) != null) {
            this.plugin.languager.commandErrorDuplicationRecipeExists(sender);
            return;
        }
        String[] targetRecParts = targetRecKey.split(":");
        NamespacedKey targetKey = new NamespacedKey(targetRecParts[0], targetRecParts[1]);
        SavedRecipe newSavedRec = new SavedRecipe(targetKey, rec.type(), rec.items(), rec.result(), rec.ingredientTypes(), rec.materialChoiceExtra(), rec.iconItem());
        this.plugin.recipeManager.setRecipe(targetRecKey, newSavedRec);
        this.plugin.languager.commandDuplicationSuccess(sender, sourceRecKey, targetRecKey);
    }

    private void resetLimits(CommandSender sender, String targetPlayerName) {
        if (targetPlayerName == null || targetPlayerName.isEmpty()) {
            this.plugin.playerCraftCounts.clear();
            this.plugin.languager.craftingLimitResetSuccess(sender);
        } else {
            Player targetPlayer = this.plugin.getServer().getPlayer(targetPlayerName);
            if (targetPlayer == null) {
                this.plugin.languager.commandErrorPlayerNotFound(sender, targetPlayerName);
                return;
            }
            Map<String, Integer> targetPlayerMap = this.plugin.playerCraftCounts.get(targetPlayer.getUniqueId());
            if (targetPlayerMap != null) {
                targetPlayerMap.clear();
            }
            this.plugin.languager.craftingLimitResetPlayerSuccess(sender, targetPlayer.getName());
        }
    }
}

