/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.commands.GreatCommands;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditRecipeCommand
implements CommandExecutor {
    private final GreatCrafts plugin;

    public EditRecipeCommand(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String recipeName = args[0];
        SavedRecipe savedRecipe = this.plugin.recipeManager.getRecipe(recipeName);
        if (savedRecipe == null) {
            this.plugin.languager.commandErrorRecipeNotExist(sender, recipeName);
            return true;
        }
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                this.plugin.languager.commandErrorPlayerRequired(sender);
                return true;
            }
            Player player = (Player)sender;
            if (player.getGameMode() != GameMode.CREATIVE) {
                this.plugin.languager.commandErrorCreativeRequired((CommandSender)player);
                return true;
            }
            this.plugin.guiCraftEditor.openNew(player, recipeName);
            return true;
        }
        String setting = GreatCommands.argumentStringFromChoices(1, args, new String[]{"show-settings", "auto-unlock-setting", "permission-requirement", "crafting-limit"});
        if (setting == null) {
            this.plugin.languager.commandErrorMustBeOneOfChoices(sender, "setting to change", "show-settings", "auto-unlock-setting", "permission-requirement", "crafting-limit");
            return true;
        }
        if (setting.equals("show-settings")) {
            String autoUnlockSetting = this.plugin.autoUnlockExceptions.containsKey(recipeName) ? String.format("\u00a7e%s \u00a77(set)", new Object[]{this.plugin.autoUnlockExceptions.get(recipeName)}) : String.format("\u00a7e%s \u00a77(plugin-wide default setting)", new Object[]{this.plugin.autoUnlockSetting});
            String permissionReq = this.plugin.recipePermissionRequirements.containsKey(recipeName) ? String.format("\u00a7e%s", this.plugin.recipePermissionRequirements.getOrDefault(recipeName, null)) : "\u00a77(none)";
            String craftingLimit = this.plugin.recipeCraftingLimits.containsKey(recipeName) ? String.format("\u00a7e%d \u00a77(per player, stacked items only)", this.plugin.recipeCraftingLimits.get(recipeName)) : "\u00a77(unlimited)";
            TextComponent auto1 = new TextComponent("\u00a76auto unlock setting\u00a77: " + autoUnlockSetting + " ");
            TextComponent auto2 = new TextComponent("\u00a79[click to edit]");
            auto2.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/editrecipe %s auto-unlock-setting ", recipeName)));
            auto1.addExtra((BaseComponent)auto2);
            sender.spigot().sendMessage((BaseComponent)auto1);
            TextComponent permission1 = new TextComponent("\u00a76permission requirement\u00a77: " + permissionReq + " ");
            TextComponent permission2 = new TextComponent("\u00a79[click to edit]");
            permission2.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/editrecipe %s permission-requirement ", recipeName)));
            permission1.addExtra((BaseComponent)permission2);
            sender.spigot().sendMessage((BaseComponent)permission1);
            TextComponent limit1 = new TextComponent("\u00a76crafting limit\u00a77: " + craftingLimit + " ");
            TextComponent limit2 = new TextComponent("\u00a79[click to edit]");
            limit2.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/editrecipe %s crafting-limit ", recipeName)));
            limit1.addExtra((BaseComponent)limit2);
            sender.spigot().sendMessage((BaseComponent)limit1);
            return true;
        }
        if (setting.equals("auto-unlock-setting")) {
            String value = GreatCommands.argumentStringFromChoices(2, args, new String[]{"never", "have-each", "have-one", "always", "default"});
            if (value == null) {
                this.plugin.languager.commandErrorMustBeOneOfChoices(sender, "auto-unlock-setting setting", "never", "have-each", "have-one", "always", "default");
                return true;
            }
            if (value.equals("default")) {
                this.plugin.getConfig().set(String.format("automatically-unlock-recipes-exceptions.%s", recipeName), null);
            } else {
                this.plugin.getConfig().set(String.format("automatically-unlock-recipes-exceptions.%s", recipeName), (Object)value);
            }
            this.plugin.saveConfig();
            this.plugin.updateConfigVars();
            this.plugin.languager.commandExtraSettingSuccess(sender, recipeName, "auto-unlock-setting", value);
            return true;
        }
        if (setting.equals("permission-requirement")) {
            String value = GreatCommands.argumentString(2, args);
            this.plugin.getConfig().set(String.format("recipe-permission-requirements.%s", recipeName), (Object)value);
            this.plugin.saveConfig();
            this.plugin.updateConfigVars();
            if (value == null) {
                this.plugin.languager.commandPermissionReqRemoveSuccess(sender);
            } else {
                this.plugin.languager.commandExtraSettingSuccess(sender, recipeName, "permission-requirement", value);
            }
            return true;
        }
        if (setting.equals("crafting-limit")) {
            Integer value = GreatCommands.argumentInteger(2, args);
            if (value == null) {
                this.plugin.languager.commandErrorIntegerRequired(sender);
                return true;
            }
            this.plugin.getConfig().set(String.format("recipe-crafting-limits.%s", recipeName), (Object)value);
            this.plugin.saveConfig();
            this.plugin.updateConfigVars();
            if (value == 0) {
                this.plugin.languager.commandCraftingLimitRemoveSuccess(sender);
            } else {
                this.plugin.languager.commandExtraSettingSuccess(sender, recipeName, "crafting-limit", String.valueOf(value));
            }
            return true;
        }
        return false;
    }
}

