/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.Arrays;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddRecipeCommand
implements CommandExecutor {
    private final GreatCrafts plugin;

    public AddRecipeCommand(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.languager.commandErrorPlayerRequired(sender);
            return true;
        }
        Player player = (Player)sender;
        if (player.getGameMode() != GameMode.CREATIVE) {
            this.plugin.languager.commandErrorCreativeRequired((CommandSender)player);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String recipeName = args[0];
        String[] recipeNameParts = recipeName.split(":");
        if (recipeNameParts.length != 2) {
            this.plugin.languager.commandErrorRecipeKeyFormat((CommandSender)player);
            return true;
        }
        if (recipeNameParts[0].matches("[^a-z0-9_\\-.]+")) {
            this.plugin.languager.commandErrorRecipeKeyNamespace((CommandSender)player);
            return true;
        }
        if (recipeNameParts[1].matches("[^a-z0-9_\\-./]+")) {
            this.plugin.languager.commandErrorRecipeKeyKey((CommandSender)player);
            return true;
        }
        NamespacedKey key = new NamespacedKey(recipeNameParts[0], recipeNameParts[1]);
        if (this.plugin.recipeManager.getRecipe(key.toString()) != null) {
            this.plugin.languager.commandErrorRecipeExists((CommandSender)player);
            return true;
        }
        List<ItemStack> items = Arrays.asList(null, null, null, null, new ItemStack(Material.EMERALD_ORE, 1), null, null, null, null);
        ItemStack iconItem = Util.createItemStack(Material.EMERALD_BLOCK, 1, "\u00a7dDefault Icon", "\u00a77This is the icon for your recipe. This is displayed in the menu", "\u00a77and doesn't affect the craft.");
        this.plugin.recipeManager.setRecipe(key.toString(), new SavedRecipe(key, RecipeType.SHAPED, items, new ItemStack(Material.EMERALD_BLOCK, 1), IngredientType.defaults(), Util.defaultMaterialChoiceExtra(), iconItem));
        this.plugin.guiCraftEditor.openNew(player, recipeName);
        return true;
    }
}

