/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts;

import io.github.greatericontop.greatcrafts.commands.AddRecipeCommand;
import io.github.greatericontop.greatcrafts.commands.DeleteRecipeCommand;
import io.github.greatericontop.greatcrafts.commands.EditRecipeCommand;
import io.github.greatericontop.greatcrafts.commands.GCUtilCommand;
import io.github.greatericontop.greatcrafts.commands.GreatCraftsCommand;
import io.github.greatericontop.greatcrafts.commands.RecipeListCommand;
import io.github.greatericontop.greatcrafts.commands.ReloadRecipesCommand;
import io.github.greatericontop.greatcrafts.commands.ViewRecipeCommand;
import io.github.greatericontop.greatcrafts.commands.tabcompleters.AddRecipeTabCompleter;
import io.github.greatericontop.greatcrafts.commands.tabcompleters.EditRecipeTabCompleter;
import io.github.greatericontop.greatcrafts.commands.tabcompleters.GCUtilTabCompleter;
import io.github.greatericontop.greatcrafts.commands.tabcompleters.RecipeListTabCompleter;
import io.github.greatericontop.greatcrafts.commands.tabcompleters.ViewRecipeTabCompleter;
import io.github.greatericontop.greatcrafts.events.AutoUnlockListener;
import io.github.greatericontop.greatcrafts.events.CrafterEvents;
import io.github.greatericontop.greatcrafts.events.InventoryCloseListener;
import io.github.greatericontop.greatcrafts.events.PermissionRestrictionListener;
import io.github.greatericontop.greatcrafts.events.StackedItemsCraftListener;
import io.github.greatericontop.greatcrafts.gui.CraftEditor;
import io.github.greatericontop.greatcrafts.gui.CraftReadOnlyViewer;
import io.github.greatericontop.greatcrafts.gui.ExactChoiceToggler;
import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.gui.MaterialChoiceEditor;
import io.github.greatericontop.greatcrafts.gui.MaterialChoiceToggler;
import io.github.greatericontop.greatcrafts.gui.RecipeListMenu;
import io.github.greatericontop.greatcrafts.internal.CraftLimitDataManager;
import io.github.greatericontop.greatcrafts.internal.Languager;
import io.github.greatericontop.greatcrafts.internal.RecipeManager;
import io.github.greatericontop.greatcrafts.internal.datastructures.AutoUnlockSetting;
import io.github.greatericontop.greatcrafts.updatechecker.UpdateChecker;
import io.github.greatericontop.greatcrafts.updatechecker.UpdateCheckerPlayerJoinListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GreatCrafts
extends JavaPlugin {
    public AutoUnlockSetting autoUnlockSetting;
    public Map<String, AutoUnlockSetting> autoUnlockExceptions;
    public Map<String, String> recipePermissionRequirements;
    public Map<String, Integer> recipeCraftingLimits;
    public boolean persistentCraftingLimits;
    public boolean doUpdateCheck;
    public Languager languager;
    public long saveAllFrequency;
    public YamlConfiguration recipes;
    public RecipeManager recipeManager;
    public Map<UUID, Map<String, Integer>> playerCraftCounts;
    public CraftEditor guiCraftEditor;
    public CraftReadOnlyViewer guiCraftReadOnlyViewer;
    public ExactChoiceToggler guiExactChoiceToggler;
    public MaterialChoiceToggler guiMaterialChoiceToggler;
    public MaterialChoiceEditor guiMaterialChoiceEditor;
    public RecipeListMenu guiRecipeListMenu;
    public String latestVersion = null;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.updateConfigVars();
        File recipeFile = new File(this.getDataFolder(), "recipes.yml");
        this.recipes = YamlConfiguration.loadConfiguration((File)recipeFile);
        this.recipeManager = new RecipeManager(this);
        if (this.persistentCraftingLimits) {
            this.playerCraftCounts = CraftLimitDataManager.fromYamlConfiguration(this);
            this.getLogger().info("Persistent craft limits is on; successfully loaded craft counts from file!");
        } else {
            this.playerCraftCounts = new HashMap<UUID, Map<String, Integer>>();
        }
        GreatCraftsCommand greatcraftscommand = new GreatCraftsCommand(this);
        this.getCommand("greatcrafts").setExecutor((CommandExecutor)greatcraftscommand);
        this.getCommand("greatcrafts").setTabCompleter((TabCompleter)greatcraftscommand);
        this.getCommand("recipes").setExecutor((CommandExecutor)new RecipeListCommand(this));
        this.getCommand("recipes").setTabCompleter((TabCompleter)new RecipeListTabCompleter());
        this.getCommand("viewrecipe").setExecutor((CommandExecutor)new ViewRecipeCommand(this));
        this.getCommand("viewrecipe").setTabCompleter((TabCompleter)new ViewRecipeTabCompleter(this));
        this.getCommand("addrecipe").setExecutor((CommandExecutor)new AddRecipeCommand(this));
        this.getCommand("addrecipe").setTabCompleter((TabCompleter)new AddRecipeTabCompleter());
        this.getCommand("editrecipe").setExecutor((CommandExecutor)new EditRecipeCommand(this));
        this.getCommand("editrecipe").setTabCompleter((TabCompleter)new EditRecipeTabCompleter(this));
        this.getCommand("deleterecipe").setExecutor((CommandExecutor)new DeleteRecipeCommand(this));
        this.getCommand("deleterecipe").setTabCompleter((TabCompleter)new ViewRecipeTabCompleter(this));
        this.getCommand("reloadrecipes").setExecutor((CommandExecutor)new ReloadRecipesCommand(this));
        this.getCommand("greatcraftsutil").setExecutor((CommandExecutor)new GCUtilCommand(this));
        this.getCommand("greatcraftsutil").setTabCompleter((TabCompleter)new GCUtilTabCompleter(this));
        GUIManager guiManager = new GUIManager(this);
        this.guiCraftEditor = new CraftEditor(guiManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiCraftEditor, (Plugin)this);
        this.guiCraftReadOnlyViewer = new CraftReadOnlyViewer(guiManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiCraftReadOnlyViewer, (Plugin)this);
        this.guiExactChoiceToggler = new ExactChoiceToggler(guiManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiExactChoiceToggler, (Plugin)this);
        this.guiMaterialChoiceToggler = new MaterialChoiceToggler(guiManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiMaterialChoiceToggler, (Plugin)this);
        this.guiMaterialChoiceEditor = new MaterialChoiceEditor(guiManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiMaterialChoiceEditor, (Plugin)this);
        this.guiRecipeListMenu = new RecipeListMenu(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.guiRecipeListMenu, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AutoUnlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryCloseListener(guiManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PermissionRestrictionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new StackedItemsCraftListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateCheckerPlayerJoinListener(this), (Plugin)this);
        String rawVersion = Bukkit.getServer().getBukkitVersion();
        String minecraftVersion = rawVersion.split("-")[0];
        int majorVersion = Integer.parseInt(minecraftVersion.split("\\.")[1]);
        this.getLogger().info("Minecraft (major) version: " + majorVersion);
        if (majorVersion >= 21) {
            this.getLogger().info("(1.21+) Enabling support for crafter block");
            this.getServer().getPluginManager().registerEvents((Listener)new CrafterEvents(this), (Plugin)this);
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::saveAll, this.saveAllFrequency, this.saveAllFrequency);
        if (this.doUpdateCheck) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                this.latestVersion = UpdateChecker.getLatestVersion((Plugin)this);
            }, 10L, 1728000L);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"greatcrafts:reloadrecipes"), 20L);
    }

    public void onDisable() {
        this.saveAll();
    }

    public void updateConfigVars() {
        this.autoUnlockSetting = AutoUnlockSetting.fromConfig(this.getConfig().getString("automatically-unlock-recipes"));
        if (this.autoUnlockSetting == null) {
            this.getLogger().warning("config option automatically-unlock-recipes was missing or invalid");
            this.autoUnlockSetting = AutoUnlockSetting.NEVER;
        }
        this.getLogger().info(String.format("  autoUnlockSetting = %s", this.autoUnlockSetting.name()));
        Map autoUnlockExceptionsRaw = this.getConfig().getConfigurationSection("automatically-unlock-recipes-exceptions").getValues(false);
        this.autoUnlockExceptions = new HashMap<String, AutoUnlockSetting>();
        for (Map.Entry entry : autoUnlockExceptionsRaw.entrySet()) {
            String string = entry.getValue().toString();
            AutoUnlockSetting setting = AutoUnlockSetting.fromConfig(string);
            if (setting == null) {
                this.getLogger().warning(String.format("automatically-unlock-recipes-exceptions: invalid value for %s ('%s'); skipping", entry.getKey(), string));
                continue;
            }
            this.getLogger().info(String.format("  automatically-unlock-recipes-exceptions: %s = %s", entry.getKey(), setting.name()));
            this.autoUnlockExceptions.put((String)entry.getKey(), setting);
        }
        Map recipePermissionRequirementsRaw = this.getConfig().getConfigurationSection("recipe-permission-requirements").getValues(false);
        this.recipePermissionRequirements = new HashMap<String, String>();
        for (Map.Entry entry : recipePermissionRequirementsRaw.entrySet()) {
            String value = entry.getValue().toString();
            this.getLogger().info(String.format("  recipe-permission-requirements: %s = %s", entry.getKey(), value));
            this.recipePermissionRequirements.put((String)entry.getKey(), value);
        }
        Map recipeCraftingLimitsRaw = this.getConfig().getConfigurationSection("recipe-crafting-limits").getValues(false);
        this.recipeCraftingLimits = new HashMap<String, Integer>();
        for (Map.Entry entry : recipeCraftingLimitsRaw.entrySet()) {
            String value = entry.getValue().toString();
            try {
                int limit = Integer.parseInt(value);
                if (limit <= 0) {
                    throw new NumberFormatException();
                }
                this.getLogger().info(String.format("  recipe-crafting-limits: %s = %d", entry.getKey(), limit));
                this.recipeCraftingLimits.put((String)entry.getKey(), limit);
            }
            catch (NumberFormatException e) {
                this.getLogger().warning(String.format("recipe-crafting-limits: invalid value for %s ('%s'); skipping", entry.getKey(), value));
            }
        }
        this.persistentCraftingLimits = this.getConfig().getBoolean("persistent-crafting-limits", false);
        this.getLogger().info(String.format("  persistentCraftingLimits = %s", this.persistentCraftingLimits));
        this.doUpdateCheck = this.getConfig().getBoolean("do-update-check", true);
        this.getLogger().info(String.format("  doUpdateCheck = %s", this.doUpdateCheck));
        this.saveAllFrequency = this.getConfig().getLong("save-all-frequency-ticks", 1200L);
        if (this.saveAllFrequency < 1L) {
            this.getLogger().warning(String.format("config option save-all-frequency-ticks (=%d) must be >=1; fall back to default", this.saveAllFrequency));
            this.saveAllFrequency = 1200L;
        }
        this.getLogger().info(String.format("  saveAllFrequency = %d ticks", this.saveAllFrequency));
        this.languager = new Languager(this);
        this.getLogger().info("  Languager ready!");
    }

    public void saveAll() {
        try {
            this.recipes.save(new File(this.getDataFolder(), "recipes.yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save recipes.yml due to IOException");
            e.printStackTrace();
        }
        if (this.persistentCraftingLimits) {
            CraftLimitDataManager.saveToYamlConfiguration(this, this.playerCraftCounts);
        }
    }
}

