/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.utils;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.utils.DefaultFontInfo;
import com.github.firewolf8385.playerpasswords.utils.VersionUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChatUtils {
    private static final int CENTER_PX = 154;
    private static BukkitAudiences adventure;
    private static PlayerPasswordsPlugin plugin;

    public static void initialize(@NotNull PlayerPasswordsPlugin pl) {
        plugin = pl;
        adventure = BukkitAudiences.create((Plugin)pl);
    }

    public static void disable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    public static String centerText(String message) {
        if (message.isEmpty()) {
            return message;
        }
        String translated = ChatColor.translateAlternateColorCodes((char)'&', (String)MiniMessage.miniMessage().stripTags(ChatUtils.toLegacy(message)));
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : translated.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb + message;
    }

    public static void chat(@NotNull CommandSender sender, @NotNull String message) {
        adventure.sender(sender).sendMessage(ChatUtils.translate(message));
    }

    public static void chat(@NotNull Player player, @NotNull String message) {
        if (plugin.getHookManager().usePlaceholderAPI()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        adventure.sender((CommandSender)player).sendMessage(ChatUtils.translate(message));
    }

    public static Component translate(@NotNull String message) {
        message = message.replace("<color1>", plugin.getConfigManager().getConfig().getString("color1")).replace("<color2>", plugin.getConfigManager().getConfig().getString("color2")).replace("<color3>", plugin.getConfigManager().getConfig().getString("color3"));
        String[] lines = message.replaceAll("\n", "<newline>").split("<newline>");
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("<center>")) {
                builder.append(ChatUtils.centerText(line.replaceFirst("<center>", ""))).append("<newline>");
                continue;
            }
            builder.append(line).append("<newline>");
        }
        String result = builder.toString();
        if (result.contains("<newline>")) {
            return MiniMessage.miniMessage().deserialize(ChatUtils.replaceLegacy(result.substring(0, result.length() - 9)));
        }
        return MiniMessage.miniMessage().deserialize(ChatUtils.replaceLegacy(result));
    }

    public static String replaceLegacy(@NotNull String message) {
        if (VersionUtils.getServerVersion() >= 16) {
            Pattern pattern = Pattern.compile("&#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start() + 1, matcher.end());
                message = message.replace("&" + color, "<reset><color:" + color + ">");
                matcher = pattern.matcher(message);
            }
        }
        return message.replace("\\n", "<newline>").replace("\u00a7", "&").replace("&0", "<reset><black>").replace("&1", "<reset><dark_blue>").replace("&2", "<reset><dark_green>").replace("&3", "<reset><dark_aqua>").replace("&4", "<reset><dark_red>").replace("&5", "<reset><dark_purple>").replace("&6", "<reset><gold>").replace("&7", "<reset><gray>").replace("&8", "<reset><dark_gray>").replace("&9", "<reset><blue>").replace("&a", "<reset><green>").replace("&b", "<reset><aqua>").replace("&c", "<reset><red>").replace("&d", "<reset><light_purple>").replace("&e", "<reset><yellow>").replace("&f", "<reset><white>").replace("&k", "<obfuscated>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<u>").replace("&o", "<i>").replace("&r", "<reset>");
    }

    public static String toLegacy(Component component) {
        return ((String)MiniMessage.miniMessage().serialize(component)).replace("<black>", "\u00a70").replace("<dark_blue>", "&1").replace("<dark_green>", "&2").replace("<dark_aqua>", "&3").replace("<dark_red>", "&4").replace("<dark_purple>", "&5").replace("<gold>", "&6").replace("<gray>", "&7").replace("<dark_gray>", "&8").replace("<blue>", "&9").replace("<green>", "&a").replace("<aqua>", "&b").replace("<red>", "&c").replace("<light_purple>", "&d").replace("<yellow>", "&e").replace("<white>", "&f").replace("<obfuscated>", "&k").replace("<obf>", "&k").replace("<bold>", "&l").replace("<b>", "&l").replace("<strikethrough>", "&m").replace("<st>", "&m").replace("<underline>", "&n").replace("<u>", "&n").replace("<i>", "&o").replace("<italic>", "&o").replace("<reset>", "&r").replace("</black>", "").replace("</dark_blue>", "").replace("</dark_green>", "").replace("</dark_aqua>", "").replace("</dark_red>", "").replace("</dark_purple>", "").replace("</gold>", "").replace("</gray>", "").replace("</dark_gray>", "").replace("</blue>", "").replace("</green>", "").replace("</aqua>", "").replace("</red>", "").replace("</light_purple>", "").replace("</yellow>", "").replace("</white>", "").replace("</obfuscated>", "").replace("</obf>", "").replace("</bold>", "").replace("</b>", "").replace("</strikethrough>", "").replace("</st>", "").replace("</underline>", "").replace("</u>", "").replace("</i>", "").replace("</italic>", "");
    }

    public static String toLegacy(String message) {
        return message.replace("<black>", "\u00a70").replace("<dark_blue>", "&1").replace("<dark_green>", "&2").replace("<dark_aqua>", "&3").replace("<dark_red>", "&4").replace("<dark_purple>", "&5").replace("<gold>", "&6").replace("<gray>", "&7").replace("<dark_gray>", "&8").replace("<blue>", "&9").replace("<green>", "&a").replace("<aqua>", "&b").replace("<red>", "&c").replace("<light_purple>", "&d").replace("<yellow>", "&e").replace("<white>", "&f").replace("<obfuscated>", "&k").replace("<obf>", "&k").replace("<bold>", "&l").replace("<b>", "&l").replace("<strikethrough>", "&m").replace("<st>", "&m").replace("<underline>", "&n").replace("<u>", "&n").replace("<i>", "&o").replace("<italic>", "&o").replace("<reset>", "&r").replace("</black>", "").replace("</dark_blue>", "").replace("</dark_green>", "").replace("</dark_aqua>", "").replace("</dark_red>", "").replace("</dark_purple>", "").replace("</gold>", "").replace("</gray>", "").replace("</dark_gray>", "").replace("</blue>", "").replace("</green>", "").replace("</aqua>", "").replace("</red>", "").replace("</light_purple>", "").replace("</yellow>", "").replace("</white>", "").replace("</obfuscated>", "").replace("</obf>", "").replace("</bold>", "").replace("</b>", "").replace("</strikethrough>", "").replace("</st>", "").replace("</underline>", "").replace("</u>", "").replace("</i>", "").replace("</italic>", "");
    }
}

