/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.settings;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.Tuple;
import java.io.File;
import java.io.IOException;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final PlayerPasswordsPlugin plugin;
    private FileConfiguration config;
    private final File configFile;
    private FileConfiguration data;
    private final File dataFile;
    private FileConfiguration messages;
    private final File messagesFile;

    public ConfigManager(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.config.options().copyDefaults(true);
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        plugin.saveConfig();
        this.messagesFile = new File(plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public String getMessage(ConfigMessage configMessage) {
        String message = configMessage.getDefaultMessage();
        if (this.messages.isSet(configMessage.getKey())) {
            message = this.messages.getString(configMessage.getKey());
        }
        message = message.replace("\\n", "<newline>");
        return message;
    }

    @SafeVarargs
    public final String getMessage(@NotNull Player player, ConfigMessage configMessage, Tuple<String, String> ... placeholders) {
        String message = this.getMessage(configMessage);
        for (Tuple<String, String> placeholder : placeholders) {
            message = message.replace(placeholder.getLeft(), placeholder.getRight());
        }
        message = message.replace("%player_name%", player.getName());
        if (this.plugin.getHookManager().usePlaceholderAPI()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        return message;
    }

    public boolean isChatBlocked() {
        if (!this.config.isSet("BlockChat")) {
            return false;
        }
        return this.config.getBoolean("BlockChat");
    }

    public boolean isCommandsBlocked() {
        if (!this.config.isSet("BlockCommands")) {
            return false;
        }
        return this.config.getBoolean("BlockCommands");
    }

    public boolean isInteractBlocked() {
        if (!this.config.isSet("BlockInteract")) {
            return false;
        }
        return this.config.getBoolean("BlockInteract");
    }

    public boolean isInventoryClickBlocked() {
        if (!this.config.isSet("BlockInventoryClick")) {
            return false;
        }
        return this.config.getBoolean("BlockInventoryClick");
    }

    public boolean isItemDropBlocked() {
        if (!this.config.isSet("BlockItemDrop")) {
            return false;
        }
        return this.config.getBoolean("BlockItemDrop");
    }

    public boolean isMovementBlocked() {
        if (!this.config.isSet("BlockMovement")) {
            return false;
        }
        return this.config.getBoolean("BlockMovement");
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reloadData() {
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void reloadMessages() {
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void saveData() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

