/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.player;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PasswordPlayer {
    private final PlayerPasswordsPlugin plugin;
    private final boolean required;
    private boolean verified;
    private final Player player;
    private int loginAttempts = 0;
    private String password = "";

    public PasswordPlayer(@NotNull PlayerPasswordsPlugin plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
        boolean optional = plugin.getConfigManager().getConfig().getBoolean("Optional");
        boolean enabled = plugin.getConfigManager().getData().getBoolean("passwords." + player.getUniqueId() + ".enabled");
        boolean requiredPerm = player.hasPermission("playerpasswords.required");
        boolean bypass = player.hasPermission("playerpasswords.bypass");
        if (enabled) {
            this.verified = false;
            this.required = true;
            return;
        }
        if (!(!requiredPerm && optional || bypass)) {
            this.verified = false;
            this.required = true;
            return;
        }
        this.verified = true;
        this.required = false;
    }

    public void addLoginAttempt() {
        ++this.loginAttempts;
    }

    public int getLoginAttempts() {
        return this.loginAttempts;
    }

    public String getPassword() {
        return this.password;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean hasPassword() {
        if (!this.plugin.getConfigManager().getData().isSet("passwords." + this.player.getUniqueId() + ".password")) {
            return false;
        }
        return !this.plugin.getConfigManager().getData().getString("passwords." + this.player.getUniqueId() + ".password").isEmpty();
    }

    public boolean hasPasswordEnabled() {
        return this.plugin.getConfigManager().getData().getBoolean("passwords." + this.player.getUniqueId() + ".enabled");
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }
}

