/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.listeners;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayer;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import com.github.firewolf8385.playerpasswords.utils.Tuple;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerJoinListener
implements Listener {
    private final PlayerPasswordsPlugin plugin;

    public PlayerJoinListener(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String uuid = player.getUniqueId().toString();
        this.plugin.getPasswordPlayerManager().addPlayer(player);
        PasswordPlayer passwordPlayer = this.plugin.getPasswordPlayerManager().getPlayer(player);
        if (!this.plugin.getConfigManager().getData().contains("passwords." + uuid)) {
            this.plugin.getConfigManager().getData().set("passwords." + uuid + ".password", (Object)"");
            this.plugin.getConfigManager().getData().set("passwords." + uuid + ".enabled", (Object)false);
            this.plugin.getConfigManager().saveData();
            this.plugin.getConfigManager().reloadData();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (passwordPlayer.isRequired() && !passwordPlayer.isVerified()) {
                if (this.plugin.getConfigManager().getData().getString("passwords." + uuid + ".password").isEmpty()) {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_REGISTER_TO_CONTINUE, new Tuple[0]));
                } else {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.LOGIN_LOGIN_TO_CONTINUE, new Tuple[0]));
                }
            }
        }, 5L);
    }
}

