/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.commands;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayer;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import com.github.firewolf8385.playerpasswords.utils.StringUtils;
import com.github.firewolf8385.playerpasswords.utils.Tuple;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RegisterCMD
implements CommandExecutor {
    private final PlayerPasswordsPlugin plugin;

    public RegisterCMD(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_NOT_A_PLAYER));
            return true;
        }
        Player player = (Player)sender;
        String uuid = player.getUniqueId().toString();
        PasswordPlayer passwordPlayer = this.plugin.getPasswordPlayerManager().getPlayer(player);
        boolean enabled = this.plugin.getConfigManager().getData().getBoolean("passwords." + uuid + ".enabled");
        int minimum = this.plugin.getConfigManager().getConfig().getInt("MinimumPasswordLength");
        int maximum = this.plugin.getConfigManager().getConfig().getInt("MaximumPasswordLength");
        if (passwordPlayer.isVerified()) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.LOGIN_ALREADY_LOGGED_IN, new Tuple[0]));
            return true;
        }
        if (enabled) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_ALREADY_REGISTERED, new Tuple[0]));
            return true;
        }
        if (args.length == 0) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_REGISTER_USAGE, new Tuple[0]));
            return true;
        }
        if (args[0].equalsIgnoreCase("confirm")) {
            if (passwordPlayer.getPassword().isEmpty()) {
                ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_REGISTER_USAGE, new Tuple[0]));
                return true;
            }
            if (args.length > 1) {
                if (passwordPlayer.getPassword().equals(args[1])) {
                    this.plugin.getConfigManager().getData().set("passwords." + uuid + ".password", (Object)StringUtils.hash(args[1]));
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_SET_SUCCESSFULLY, new Tuple[0]));
                    if (!passwordPlayer.isVerified()) {
                        passwordPlayer.setVerified(true);
                    }
                    if (!this.plugin.getConfigManager().getData().getBoolean("passwords." + uuid + ".enabled")) {
                        this.plugin.getConfigManager().getData().set("passwords." + uuid + ".enabled", (Object)true);
                    }
                    this.plugin.getConfigManager().saveData();
                    this.plugin.getConfigManager().reloadData();
                } else {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_INCORRECT, new Tuple[0]));
                }
                return true;
            }
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_REGISTER_CONFIRM_USAGE, new Tuple[0]));
            return true;
        }
        if (args[0].length() < minimum || args[0].length() > maximum) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_OUT_OF_BOUNDS, new Tuple[0]));
            return true;
        }
        passwordPlayer.setPassword(args[0]);
        if (this.plugin.getConfigManager().getConfig().getBoolean("RequireConfirmation")) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_CONFIRM_REGISTER, new Tuple[0]));
            return true;
        }
        this.plugin.getConfigManager().getData().set("passwords." + uuid + ".password", (Object)StringUtils.hash(args[0]));
        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_SET_SUCCESSFULLY, new Tuple[0]));
        if (!passwordPlayer.isVerified()) {
            passwordPlayer.setVerified(true);
        }
        if (!this.plugin.getConfigManager().getData().getBoolean("passwords." + uuid + ".enabled")) {
            this.plugin.getConfigManager().getData().set("passwords." + uuid + ".enabled", (Object)true);
        }
        this.plugin.getConfigManager().saveData();
        this.plugin.getConfigManager().reloadData();
        return true;
    }
}

