/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.commands;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayer;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerPasswordsCMD
implements CommandExecutor,
TabCompleter {
    private final PlayerPasswordsPlugin plugin;

    public PlayerPasswordsCMD(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("playerpasswords.admin")) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_NO_PERMISSION));
            return true;
        }
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        switch (args[0]) {
            default: {
                this.helpCMD(sender);
                break;
            }
            case "info": {
                this.infoCMD(sender);
                break;
            }
            case "list": 
            case "players": 
            case "verified": {
                this.playersCMD(sender);
                break;
            }
            case "reload": {
                this.reloadCMD(sender);
                break;
            }
            case "reset": {
                this.resetCMD(sender, args);
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 2) {
            return Arrays.asList("info", "help", "list", "players", "reload", "reset", "verified", "version");
        }
        return Collections.emptyList();
    }

    private void helpCMD(@NotNull CommandSender sender) {
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "<center><color3><st>        </st> <color1><bold>PlayerPasswords <color3><st>        </st> ");
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>/pp info <color3>- <color2>Shows plugin info.");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>/pp players <color3>- <color2>List all verified players.");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>/pp reload <color3>- <color2>Reload the plugin's config file.");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>/pp reset [player] <color3>- <color2>Reset a player's password.");
        ChatUtils.chat(sender, "");
    }

    private void infoCMD(@NotNull CommandSender sender) {
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "<center><color3><st>        </st> <color1><bold>PlayerPasswords <color3><st>        </st> ");
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>Author <color3>- <color2>firewolf8385");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>Version <color3>- <color2>" + this.plugin.getDescription().getVersion());
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>GitHub <color3>- <color2><click:open_url:'https://www.github.com/firewolf8385/PlayerPasswords'>github.com/firewolf8385/PlayerPasswords</click>");
        ChatUtils.chat(sender, "  <color3>\u00bb <color1>Modrinth <color3>- <color2><click:open_url:'https://www.modrinth.com/project/playerpasswords'>modrinth.com/project/playerpasswords</click>");
        ChatUtils.chat(sender, "");
    }

    public void playersCMD(@NotNull CommandSender sender) {
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "<center><color3><st>        </st> <color1><bold>PlayerPasswords <color3><st>        </st> ");
        ChatUtils.chat(sender, "");
        StringBuilder builder = new StringBuilder();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PasswordPlayer passwordPlayer = this.plugin.getPasswordPlayerManager().getPlayer(player);
            if (player.hasPermission("playerpasswords.bypass")) {
                builder.append("<aqua>");
            } else if (!passwordPlayer.hasPasswordEnabled()) {
                builder.append("<gray>");
            } else if (passwordPlayer.isVerified()) {
                builder.append("<green>");
            } else {
                builder.append("<red>");
            }
            builder.append(player.getName()).append("<color3>, ");
        }
        ChatUtils.chat(sender, builder.substring(0, builder.length() - 2));
        ChatUtils.chat(sender, "");
        ChatUtils.chat(sender, "<center><green>\u25a0 Verified <dark_gray>- <red>\u25a0 Not Verified <dark_gray>- <aqua>\u25a0 Exempt <dark_gray>- <gray>\u25a0 No Password");
        ChatUtils.chat(sender, "");
    }

    private void reloadCMD(@NotNull CommandSender sender) {
        this.plugin.reload();
        ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_CONFIG_RELOADED));
    }

    private void resetCMD(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length != 2) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_PASSWORD_RESET_USAGE));
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!this.plugin.getConfigManager().getData().isSet("passwords." + target.getUniqueId() + ".enabled")) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_PLAYER_DOES_NOT_EXIST));
            return;
        }
        this.plugin.getConfigManager().getData().set("passwords." + target.getUniqueId() + ".enabled", (Object)false);
        this.plugin.getConfigManager().getData().set("passwords." + target.getUniqueId() + ".password", (Object)"");
        this.plugin.getConfigManager().saveData();
        this.plugin.getConfigManager().reloadData();
        ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_PASSWORD_RESET));
    }
}

