/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.commands;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayer;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import com.github.firewolf8385.playerpasswords.utils.StringUtils;
import com.github.firewolf8385.playerpasswords.utils.Tuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PasswordCMD
implements CommandExecutor,
TabCompleter {
    private final PlayerPasswordsPlugin plugin;

    public PasswordCMD(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_NOT_A_PLAYER));
            return true;
        }
        Player player = (Player)sender;
        String uuid = player.getUniqueId().toString();
        PasswordPlayer passwordPlayer = this.plugin.getPasswordPlayerManager().getPlayer(player);
        if (!passwordPlayer.isVerified()) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.MISC_MUST_BE_LOGGED_IN, new Tuple[0]));
            return true;
        }
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        switch (args[0].toLowerCase()) {
            default: {
                ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.PASSWORD_HELP_PAGE));
                return true;
            }
            case "enable": {
                if (!sender.hasPermission("playerpasswords.enable")) {
                    ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_NO_PERMISSION));
                    return true;
                }
                if (!passwordPlayer.hasPassword()) {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_NOT_SET, new Tuple[0]));
                    return true;
                }
                this.plugin.getConfigManager().getData().set("passwords." + uuid + ".enabled", (Object)true);
                this.plugin.getConfigManager().saveData();
                this.plugin.getConfigManager().reloadData();
                ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_ENABLED, new Tuple[0]));
                return true;
            }
            case "disable": {
                if (!sender.hasPermission("playerpasswords.disable")) {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.MISC_NO_PERMISSION, new Tuple[0]));
                    return true;
                }
                if (this.plugin.getConfigManager().getConfig().getBoolean("Optional")) {
                    this.plugin.getConfigManager().getData().set("passwords." + uuid + ".enabled", (Object)false);
                    this.plugin.getConfigManager().saveData();
                    this.plugin.getConfigManager().reloadData();
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_DISABLED, new Tuple[0]));
                } else {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_OPTIONAL_PASSWORD_DISABLED, new Tuple[0]));
                }
                return true;
            }
            case "set": {
                if (!sender.hasPermission("playerpasswords.set")) {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.MISC_NO_PERMISSION, new Tuple[0]));
                    return true;
                }
                if (args.length > 1) {
                    int minimum = this.plugin.getConfigManager().getConfig().getInt("MinimumPasswordLength");
                    int maximum = this.plugin.getConfigManager().getConfig().getInt("MaximumPasswordLength");
                    if (args[1].length() < minimum || args[1].length() > maximum) {
                        Tuple<String, String> minimumPlaceholder = new Tuple<String, String>("%minimum%", minimum + "");
                        Tuple<String, String> maximumPlaceholder = new Tuple<String, String>("%maximum%", maximum + "");
                        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_OUT_OF_BOUNDS, minimumPlaceholder, maximumPlaceholder));
                        return true;
                    }
                    passwordPlayer.setPassword(args[1]);
                    if (this.plugin.getConfigManager().getConfig().getBoolean("RequireConfirmation")) {
                        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_CONFIRM_PASSWORD, new Tuple[0]));
                    } else {
                        this.plugin.getConfigManager().getData().set("passwords." + uuid + ".password", (Object)StringUtils.hash(args[1]));
                        this.plugin.getConfigManager().saveData();
                        this.plugin.getConfigManager().reloadData();
                        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_SET_SUCCESSFULLY, new Tuple[0]));
                    }
                } else {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_SET_USAGE, new Tuple[0]));
                }
                return true;
            }
            case "confirm": 
        }
        if (passwordPlayer.getPassword().isEmpty()) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_NOT_SET, new Tuple[0]));
            return true;
        }
        if (args.length > 1) {
            if (passwordPlayer.getPassword().equals(args[1])) {
                this.plugin.getConfigManager().getData().set("passwords." + uuid + ".password", (Object)StringUtils.hash(args[1]));
                this.plugin.getConfigManager().saveData();
                this.plugin.getConfigManager().reloadData();
                ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_SET_SUCCESSFULLY, new Tuple[0]));
                if (this.plugin.getConfigManager().getConfig().getBoolean("Optional") && !passwordPlayer.hasPasswordEnabled()) {
                    ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_NOT_ENABLED, new Tuple[0]));
                }
            } else {
                ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_INCORRECT, new Tuple[0]));
            }
            return true;
        }
        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_CONFIRM_USAGE, new Tuple[0]));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 2) {
            return Arrays.asList("confirm", "disable", "enable", "help", "set");
        }
        return Collections.emptyList();
    }
}

