/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords.commands;

import com.github.firewolf8385.playerpasswords.PlayerPasswordsPlugin;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayer;
import com.github.firewolf8385.playerpasswords.settings.ConfigMessage;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import com.github.firewolf8385.playerpasswords.utils.StringUtils;
import com.github.firewolf8385.playerpasswords.utils.Tuple;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LoginCMD
implements CommandExecutor {
    private final PlayerPasswordsPlugin plugin;

    public LoginCMD(@NotNull PlayerPasswordsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            ChatUtils.chat(sender, this.plugin.getConfigManager().getMessage(ConfigMessage.MISC_NOT_A_PLAYER));
            return true;
        }
        Player player = (Player)sender;
        String uuid = player.getUniqueId().toString();
        PasswordPlayer passwordPlayer = this.plugin.getPasswordPlayerManager().getPlayer(player);
        if (passwordPlayer.isVerified()) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.LOGIN_ALREADY_LOGGED_IN, new Tuple[0]));
            return true;
        }
        if (!passwordPlayer.hasPassword()) {
            if (passwordPlayer.isRequired()) {
                ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.REGISTER_REGISTER_TO_CONTINUE, new Tuple[0]));
                return true;
            }
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_NOT_SET, new Tuple[0]));
        }
        if (args.length == 0) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.LOGIN_LOGIN_USAGE, new Tuple[0]));
            return true;
        }
        if (StringUtils.hash(args[0]) == this.plugin.getConfigManager().getData().getInt("passwords." + uuid + ".password")) {
            ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.LOGIN_LOGGED_IN_SUCCESSFULLY, new Tuple[0]));
            passwordPlayer.setVerified(true);
            return true;
        }
        passwordPlayer.addLoginAttempt();
        int maxAttempts = this.plugin.getConfigManager().getConfig().getInt("MaxAttempts");
        if (maxAttempts != -1 && passwordPlayer.getLoginAttempts() >= maxAttempts) {
            for (String command : this.plugin.getConfigManager().getConfig().getStringList("FailCommands")) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
            }
            return true;
        }
        ChatUtils.chat(player, this.plugin.getConfigManager().getMessage(player, ConfigMessage.PASSWORD_PASSWORD_INCORRECT, new Tuple[0]));
        return true;
    }
}

