/*
 * Decompiled with CFR 0.152.
 */
package com.github.firewolf8385.playerpasswords;

import com.github.firewolf8385.playerpasswords.PlayerPasswords;
import com.github.firewolf8385.playerpasswords.commands.LoginCMD;
import com.github.firewolf8385.playerpasswords.commands.PasswordCMD;
import com.github.firewolf8385.playerpasswords.commands.PlayerPasswordsCMD;
import com.github.firewolf8385.playerpasswords.commands.RegisterCMD;
import com.github.firewolf8385.playerpasswords.listeners.InventoryClickListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerChatListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerCommandPreProcessListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerDropItemListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerInteractListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerJoinListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerMoveListener;
import com.github.firewolf8385.playerpasswords.listeners.PlayerQuitListener;
import com.github.firewolf8385.playerpasswords.listeners.ReloadListener;
import com.github.firewolf8385.playerpasswords.player.PasswordPlayerManager;
import com.github.firewolf8385.playerpasswords.settings.ConfigManager;
import com.github.firewolf8385.playerpasswords.settings.HookManager;
import com.github.firewolf8385.playerpasswords.utils.ChatUtils;
import com.github.firewolf8385.shaded.bstats.bukkit.Metrics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerPasswordsPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private PasswordPlayerManager passwordPlayerManager;
    private HookManager hookManager;

    public void onEnable() {
        new Metrics(this, 5190);
        this.configManager = new ConfigManager(this);
        this.hookManager = new HookManager((Plugin)this);
        this.passwordPlayerManager = new PasswordPlayerManager(this);
        this.registerCommands();
        this.registerEvents();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.passwordPlayerManager.addPlayer(player);
            this.passwordPlayerManager.getPlayer(player).setVerified(true);
        }
        ChatUtils.initialize(this);
        PlayerPasswords.initialize(this);
    }

    public void onDisable() {
        ChatUtils.disable();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public PasswordPlayerManager getPasswordPlayerManager() {
        return this.passwordPlayerManager;
    }

    private void registerCommands() {
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCMD(this));
        this.getCommand("register").setExecutor((CommandExecutor)new RegisterCMD(this));
        this.getCommand("playerpasswords").setExecutor((CommandExecutor)new PlayerPasswordsCMD(this));
        this.getCommand("password").setExecutor((CommandExecutor)new PasswordCMD(this));
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandPreProcessListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDropItemListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        if (this.hookManager.useBetterReload()) {
            this.getServer().getPluginManager().registerEvents((Listener)new ReloadListener(this), (Plugin)this);
        }
    }

    public void reload() {
        this.configManager.reloadConfig();
        this.configManager.reloadData();
        this.configManager.reloadMessages();
    }
}

