/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit;

import fi.fabianadrian.webhooklogger.dependency.io.leangen.geantyref.TypeToken;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.CommandManager;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.BukkitParserParameters;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.annotation.specifier.DefaultNamespace;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.data.MultipleEntitySelector;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.data.MultiplePlayerSelector;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.BlockPredicateParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.EnchantmentParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.ItemStackParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.ItemStackPredicateParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.MaterialParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.OfflinePlayerParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.PlayerParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.WorldParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.location.Location2DParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.location.LocationParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.parser.ParserParameters;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

