/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.dependency.io.github._4drian3d.jdwebhooks;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Embed(@Nullable String title, @Nullable String type, @Nullable String description, @Nullable String url, @Nullable OffsetDateTime timestamp, @Nullable Integer color, @Nullable Footer footer, @Nullable Image image, @Nullable Thumbnail thumbnail, @Nullable Video video, @Nullable Provider provider, @Nullable Author author, @Nullable Field[] fields) {
    public static Builder builder() {
        return new Builder();
    }

    public record Footer(@NotNull String text, @Nullable String iconURL, @Nullable String proxyIconURL) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String text;
            private String iconURL;
            private String proxyIconURL;

            private Builder() {
            }

            public Builder text(@NotNull String text) {
                this.text = Objects.requireNonNull(text, "text");
                return this;
            }

            public Builder iconURL(@Nullable String iconURL) {
                this.iconURL = iconURL;
                return this;
            }

            public Builder proxyIconURL(@Nullable String proxyIconURL) {
                this.proxyIconURL = proxyIconURL;
                return this;
            }

            public Footer build() {
                return new Footer(Objects.requireNonNull(this.text), this.iconURL, this.proxyIconURL);
            }
        }
    }

    public record Image(@NotNull String url, @Nullable String proxyURL, @Nullable String height, @Nullable String width) implements GraphicResource
    {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String url;
            private String proxyURL;
            private String height;
            private String width;

            private Builder() {
            }

            public Builder url(@NotNull String url) {
                this.url = Objects.requireNonNull(url, "url");
                return this;
            }

            public Builder proxyURL(@Nullable String proxyURL) {
                this.proxyURL = proxyURL;
                return this;
            }

            public Builder height(@Nullable String height) {
                this.height = height;
                return this;
            }

            public Builder width(@Nullable String width) {
                this.width = width;
                return this;
            }

            public Image build() {
                return new Image(Objects.requireNonNull(this.url, "url"), this.proxyURL, this.height, this.width);
            }
        }
    }

    public record Thumbnail(@NotNull String url, @Nullable String proxyURL, @Nullable String height, @Nullable String width) implements GraphicResource
    {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String url;
            private String proxyURL;
            private String height;
            private String width;

            private Builder() {
            }

            public Builder url(@NotNull String url) {
                this.url = Objects.requireNonNull(url, "url");
                return this;
            }

            public Builder proxyURL(@Nullable String proxyURL) {
                this.proxyURL = proxyURL;
                return this;
            }

            public Builder height(@Nullable String height) {
                this.height = height;
                return this;
            }

            public Builder width(@Nullable String width) {
                this.width = width;
                return this;
            }

            public Thumbnail build() {
                return new Thumbnail(Objects.requireNonNull(this.url), this.proxyURL, this.height, this.width);
            }
        }
    }

    public record Video(@NotNull String url, @Nullable String proxyURL, @Nullable String height, @Nullable String width) implements GraphicResource
    {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String url;
            private String proxyURL;
            private String height;
            private String width;

            private Builder() {
            }

            public Builder url(@NotNull String url) {
                this.url = Objects.requireNonNull(url, "url");
                return this;
            }

            public Builder proxyURL(@Nullable String proxyURL) {
                this.proxyURL = proxyURL;
                return this;
            }

            public Builder height(@Nullable String height) {
                this.height = height;
                return this;
            }

            public Builder width(@Nullable String width) {
                this.width = width;
                return this;
            }

            public Video build() {
                return new Video(Objects.requireNonNull(this.url), this.proxyURL, this.height, this.width);
            }
        }
    }

    public record Provider(@Nullable String name, @Nullable String url) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String url;

            public Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            public Builder url(@Nullable String url) {
                this.url = url;
                return this;
            }

            public Provider build() {
                return new Provider(this.name, this.url);
            }
        }
    }

    public record Author(@NotNull String name, @Nullable String url, @Nullable String iconURL, @Nullable String proxyIconURL) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private String url;
            private String iconURL;
            private String proxyIconURL;

            private Builder() {
            }

            public Builder name(@NotNull String name) {
                this.name = Objects.requireNonNull(name, "name");
                return this;
            }

            public Builder url(@Nullable String url) {
                this.url = url;
                return this;
            }

            public Builder iconURL(@Nullable String iconURL) {
                this.iconURL = iconURL;
                return this;
            }

            public Builder proxyIconURL(String proxyIconURL) {
                this.proxyIconURL = proxyIconURL;
                return this;
            }

            public Author build() {
                return new Author(Objects.requireNonNull(this.name, "name"), this.url, this.iconURL, this.proxyIconURL);
            }
        }
    }

    public record Field(@Nullable Boolean inline, @NotNull String name, @NotNull String value) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Boolean inline;
            private String name;
            private String value;

            private Builder() {
            }

            public Builder inline(@Nullable Boolean inline) {
                this.inline = inline;
                return this;
            }

            public Builder name(@NotNull String name) {
                this.name = Objects.requireNonNull(name, "name");
                return this;
            }

            public Builder value(@NotNull String value) {
                this.value = Objects.requireNonNull(value, "value");
                return this;
            }

            public Field build() {
                return new Field(this.inline, Objects.requireNonNull(this.name, "name"), Objects.requireNonNull(this.value, "value"));
            }
        }
    }

    public static final class Builder {
        private String title;
        private String type;
        private String description;
        private String url;
        private OffsetDateTime timestamp;
        private Integer color;
        private Footer footer;
        private Thumbnail thumbnail;
        private Video video;
        private Image image;
        private Author author;
        private Provider provider;
        private List<Field> fields;

        private Builder() {
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder timestamp(@Nullable Instant timestamp) {
            this.timestamp = timestamp == null ? null : OffsetDateTime.ofInstant(timestamp, Clock.systemDefaultZone().getZone());
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder timestamp(@Nullable TemporalAccessor timestamp) {
            this.timestamp = timestamp == null ? null : OffsetDateTime.from(timestamp);
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder timestamp(@Nullable OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Contract(value="_, _ -> this", mutates="this")
        public Builder timestamp(@NotNull LocalDateTime dateTime, @NotNull ZoneOffset offset) {
            Objects.requireNonNull(dateTime, "dateTime");
            Objects.requireNonNull(offset, "offset");
            this.timestamp = OffsetDateTime.of(dateTime, offset);
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder color(@Nullable Integer color) {
            this.color = color;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder footer(@Nullable Footer footer) {
            this.footer = footer;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder thumbnail(@Nullable Thumbnail thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder video(@Nullable Video video) {
            this.video = video;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder image(@Nullable Image image) {
            this.image = image;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder author(@Nullable Author author) {
            this.author = author;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder provider(@Nullable Provider provider) {
            this.provider = provider;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder field(@NotNull Field field) {
            Objects.requireNonNull(field, "field");
            if (this.fields == null) {
                this.fields = new ArrayList<Field>();
            }
            this.fields.add(field);
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder fields(@NotNull @NotNull Collection<@NotNull Field> fields) {
            Objects.requireNonNull(fields, "fields");
            for (Field field : fields) {
                this.field(field);
            }
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public Builder fields(Field ... fields) {
            Objects.requireNonNull(fields, "fields");
            for (Field field : fields) {
                this.field(field);
            }
            return this;
        }

        @Contract(value="-> new")
        @NotNull
        public Embed build() {
            return new Embed(this.title, this.type, this.description, this.url, this.timestamp, this.color, this.footer, this.image, this.thumbnail, this.video, this.provider, this.author, this.fields == null ? null : (Field[])this.fields.toArray(Field[]::new));
        }
    }

    public static interface GraphicResource {
        public String url();

        public String proxyURL();

        public String height();

        public String width();
    }
}

