/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.dependency.dev.vankka.mcdiscordreserializer.rules;

import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import dev.vankka.simpleast.core.parser.ParseSpec;
import dev.vankka.simpleast.core.parser.Parser;
import dev.vankka.simpleast.core.parser.Rule;
import dev.vankka.simpleast.core.simple.SimpleMarkdownRules;
import fi.fabianadrian.webhooklogger.dependency.dev.vankka.mcdiscordreserializer.rules.StyleNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiscordMarkdownRules {
    private static final Pattern PATTERN_EMOTE_MENTION = Pattern.compile("^<a?:(\\w+):(\\d+)>");
    private static final Pattern PATTERN_CHANNEL_MENTION = Pattern.compile("^<#(\\d+)>");
    private static final Pattern PATTERN_USER_MENTION = Pattern.compile("^<@!?(\\d+)>");
    private static final Pattern PATTERN_ROLE_MENTION = Pattern.compile("^<@&(\\d+)>");
    private static final Pattern PATTERN_BOLD = Pattern.compile("^\\*\\*(.+?)\\*\\*(?!\\*)");
    private static final Pattern PATTERN_UNDERLINE = Pattern.compile("^__(.+?)__(?!_)");
    private static final Pattern PATTERN_STRIKETHRU = Pattern.compile("^~~(.+?)~~");
    private static final Pattern PATTERN_SPOILER = Pattern.compile("^\\|\\|(.+?)\\|\\|");
    private static final Pattern PATTERN_CODE_STRING = Pattern.compile("^(?:`{2}(.+?)`{2}|`(.+?)`)");
    private static final Pattern PATTERN_QUOTE = Pattern.compile("^> (.+(?:\\n> .+)*)", 32);
    private static final Pattern PATTERN_CODE_BLOCK = Pattern.compile("^```(?:(\\S+?)\\n)?\\n*(.+?)\\n*```");
    private static final Pattern PATTERN_ITALICS = Pattern.compile("^\\b_((?:__|\\\\[\\s\\S]|[^\\\\_])+?)_\\b|^\\*(?=\\S)((?:\\*\\*|[^\\s*]\\s{0,2})+?)\\*(?!\\*)");
    private static final Pattern PATTERN_TEXT = Pattern.compile("^[\\s\\S]+?(?=[^0-9A-Za-z\\s\\u00c0-\\uffff>]|\\n| {2,}\\n|\\w+:\\S|$)");
    private static final Pattern PATTERN_LINK = Pattern.compile("^(https?://[^ ]+\\.[^ ]+)");

    private DiscordMarkdownRules() {
    }

    private static <R> StyleNode<R, StyleNode.Style> styleNode(StyleNode.Style style) {
        return new StyleNode(new ArrayList<StyleNode.Style>(Collections.singletonList(style)));
    }

    public static <R, S> Rule<R, Node<R>, S> createEmoteMentionRule() {
        return new Rule<R, Node<R>, S>(PATTERN_EMOTE_MENTION){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String name = matcher.group(1);
                String id = matcher.group(2);
                return ParseSpec.createTerminal(DiscordMarkdownRules.styleNode(new StyleNode.EmojiStyle(id, name)), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createChannelMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_CHANNEL_MENTION, StyleNode.MentionStyle.Type.CHANNEL);
    }

    public static <R, S> Rule<R, Node<R>, S> createUserMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_USER_MENTION, StyleNode.MentionStyle.Type.USER);
    }

    public static <R, S> Rule<R, Node<R>, S> createRoleMentionRule() {
        return DiscordMarkdownRules.createSimpleMentionRule(PATTERN_ROLE_MENTION, StyleNode.MentionStyle.Type.ROLE);
    }

    public static <R, S> Rule<R, Node<R>, S> createBoldRule() {
        return DiscordMarkdownRules.createSimpleStyleRule(PATTERN_BOLD, StyleNode.Styles.BOLD);
    }

    public static <R, S> Rule<R, Node<R>, S> createUnderlineRule() {
        return DiscordMarkdownRules.createSimpleStyleRule(PATTERN_UNDERLINE, StyleNode.Styles.UNDERLINE);
    }

    public static <R, S> Rule<R, Node<R>, S> createSimpleStyleRule(Pattern pattern, final StyleNode.Style style) {
        return new Rule<R, Node<R>, S>(pattern){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createNonterminal(DiscordMarkdownRules.styleNode(style), state, matcher.start(1), matcher.end(1));
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createItalicsRule() {
        return new Rule<R, Node<R>, S>(PATTERN_ITALICS){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                int endIndex;
                int startIndex;
                boolean asterisk;
                String asteriskMatch = matcher.group(2);
                boolean bl = asterisk = asteriskMatch != null && !asteriskMatch.isEmpty();
                if (asterisk) {
                    startIndex = matcher.start(2);
                    endIndex = matcher.end(2);
                } else {
                    startIndex = matcher.start(1);
                    endIndex = matcher.end(1);
                }
                StyleNode.ItalicStyle style = new StyleNode.ItalicStyle(asterisk);
                return ParseSpec.createNonterminal(new StyleNode(new ArrayList<StyleNode.ItalicStyle>(Collections.singletonList(style))), state, startIndex, endIndex);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createStrikethruRule() {
        return DiscordMarkdownRules.createSimpleStyleRule(PATTERN_STRIKETHRU, StyleNode.Styles.STRIKETHROUGH);
    }

    public static <R, S> Rule<R, Node<R>, S> createSpoilerRule() {
        return new Rule<R, Node<R>, S>(PATTERN_SPOILER){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String content = matcher.group(1);
                return ParseSpec.createTerminal(DiscordMarkdownRules.styleNode(new StyleNode.ContentStyle(StyleNode.ContentStyle.Type.SPOILER, content)), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createCodeStringRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_STRING){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String content = matcher.group(1);
                if (content == null) {
                    content = matcher.group(2);
                }
                return ParseSpec.createTerminal(StyleNode.createWithText(content, new ArrayList<StyleNode.Style>(Collections.singletonList(StyleNode.Styles.CODE_STRING))), state);
            }
        };
    }

    private static <R, S> Rule<R, Node<R>, S> createSimpleMentionRule(Pattern pattern, final StyleNode.MentionStyle.Type style) {
        return new Rule<R, Node<R>, S>(pattern){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String id = matcher.group(1);
                StyleNode.MentionStyle mentionStyle = new StyleNode.MentionStyle(style, id);
                return ParseSpec.createTerminal(DiscordMarkdownRules.styleNode(mentionStyle), state);
            }
        };
    }

    public static <R> Rule<R, Node<R>, Object> createQuoteRule() {
        return new Rule<R, Node<R>, Object>(PATTERN_QUOTE){

            @Override
            public Matcher match(CharSequence inspectionSource, String lastCapture, Object state) {
                if (state instanceof QuoteState && ((QuoteState)state).isInQuote) {
                    return null;
                }
                return super.match(inspectionSource, lastCapture, state);
            }

            @Override
            public ParseSpec<R, Node<R>, Object> parse(Matcher matcher, Parser parser, Object state) {
                QuoteState newState = state instanceof QuoteState ? ((QuoteState)state).newQuoteState(true) : new QuoteState(true);
                String content = matcher.group(1).trim().replace("\n> ", "\n");
                return ParseSpec.createNonterminal(DiscordMarkdownRules.styleNode(new StyleNode.ContentStyle(StyleNode.ContentStyle.Type.QUOTE, content)), newState, matcher.start(1), matcher.end(1));
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createCodeBlockRule() {
        return new Rule<R, Node<R>, S>(PATTERN_CODE_BLOCK){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String language = matcher.group(1);
                return ParseSpec.createTerminal(StyleNode.createWithText(matcher.group(2), new ArrayList<StyleNode.Style>(Collections.singletonList(new StyleNode.CodeBlockStyle(language)))), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createSpecialTextRule() {
        return new Rule<R, Node<R>, S>(PATTERN_TEXT){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createTerminal(new TextNode(matcher.group()), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createLinkRule() {
        return new Rule<R, Node<R>, S>(PATTERN_LINK){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String link = matcher.group(1);
                return ParseSpec.createTerminal(DiscordMarkdownRules.styleNode(new StyleNode.ContentStyle(StyleNode.ContentStyle.Type.LINK, link)), state);
            }
        };
    }

    public static <R, S> List<Rule<R, Node<R>, S>> createMentionRules() {
        ArrayList<Rule<R, Node<R>, S>> rules = new ArrayList<Rule<R, Node<R>, S>>();
        rules.add(DiscordMarkdownRules.createEmoteMentionRule());
        rules.add(DiscordMarkdownRules.createChannelMentionRule());
        rules.add(DiscordMarkdownRules.createUserMentionRule());
        rules.add(DiscordMarkdownRules.createRoleMentionRule());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createStyleRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.add(DiscordMarkdownRules.createQuoteRule());
        rules.add(DiscordMarkdownRules.createSpoilerRule());
        rules.add(DiscordMarkdownRules.createCodeBlockRule());
        rules.add(DiscordMarkdownRules.createCodeStringRule());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createDiscordMarkdownRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(DiscordMarkdownRules.createStyleRules());
        rules.addAll(DiscordMarkdownRules.createMentionRules());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createSimpleMarkdownRules() {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.add(SimpleMarkdownRules.createEscapeRule());
        rules.add(DiscordMarkdownRules.createLinkRule());
        rules.add(SimpleMarkdownRules.createNewlineRule());
        rules.add(DiscordMarkdownRules.createBoldRule());
        rules.add(DiscordMarkdownRules.createUnderlineRule());
        rules.add(DiscordMarkdownRules.createItalicsRule());
        rules.add(DiscordMarkdownRules.createStrikethruRule());
        return rules;
    }

    public static <R> List<Rule<R, Node<R>, Object>> createAllRulesForDiscord(boolean includeText) {
        ArrayList<Rule<R, Node<R>, Object>> rules = new ArrayList<Rule<R, Node<R>, Object>>();
        rules.addAll(DiscordMarkdownRules.createSimpleMarkdownRules());
        rules.addAll(DiscordMarkdownRules.createDiscordMarkdownRules());
        if (includeText) {
            rules.add(DiscordMarkdownRules.createSpecialTextRule());
        }
        return rules;
    }

    public static class QuoteState {
        private boolean isInQuote;

        public QuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
        }

        public QuoteState newQuoteState(boolean isInQuote) {
            this.isInQuote = isInQuote;
            return this;
        }
    }
}

