/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.dependency.dev.vankka.mcdiscordreserializer.discord;

import java.util.function.Function;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import org.jetbrains.annotations.NotNull;

public final class DiscordSerializerOptions {
    private final boolean maskedLinks;
    private final boolean escapeMarkdown;
    @NotNull
    private final ComponentFlattener flattener;

    public static DiscordSerializerOptions defaults() {
        return new DiscordSerializerOptions(false, true, (ComponentFlattener)ComponentFlattener.builder().mapper(TextComponent.class, TextComponent::content).mapper(ScoreComponent.class, ScoreComponent::value).mapper(SelectorComponent.class, SelectorComponent::pattern).build());
    }

    public DiscordSerializerOptions(boolean embedLinks, boolean escapeMarkdown, @NotNull Function<KeybindComponent, String> keybindProvider, @NotNull Function<TranslatableComponent, String> translationProvider) {
        this(embedLinks, escapeMarkdown, (ComponentFlattener)ComponentFlattener.builder().mapper(KeybindComponent.class, keybindProvider).mapper(TranslatableComponent.class, translationProvider).build());
    }

    public DiscordSerializerOptions(boolean maskedLinks, boolean escapeMarkdown, @NotNull ComponentFlattener flattener) {
        this.maskedLinks = maskedLinks;
        this.escapeMarkdown = escapeMarkdown;
        this.flattener = flattener;
    }

    public boolean isMaskedLinks() {
        return this.maskedLinks;
    }

    public DiscordSerializerOptions withMaskedLinks(boolean maskedLinks) {
        return new DiscordSerializerOptions(maskedLinks, this.escapeMarkdown, this.flattener);
    }

    public boolean isEscapeMarkdown() {
        return this.escapeMarkdown;
    }

    public DiscordSerializerOptions withEscapeMarkdown(boolean escapeMarkdown) {
        return new DiscordSerializerOptions(this.maskedLinks, escapeMarkdown, this.flattener);
    }

    @NotNull
    public ComponentFlattener getFlattener() {
        return this.flattener;
    }

    public DiscordSerializerOptions withFlattener(ComponentFlattener flattener) {
        return new DiscordSerializerOptions(this.maskedLinks, this.escapeMarkdown, flattener);
    }

    @Deprecated
    public boolean isEmbedLinks() {
        return this.maskedLinks;
    }

    @Deprecated
    public DiscordSerializerOptions withEmbedLinks(boolean embedLinks) {
        return new DiscordSerializerOptions(embedLinks, this.escapeMarkdown, this.flattener);
    }

    @Deprecated
    @NotNull
    public Function<KeybindComponent, String> getKeybindProvider() {
        return component -> "";
    }

    @Deprecated
    public DiscordSerializerOptions withKeybindProvider(Function<KeybindComponent, String> keybindProvider) {
        return new DiscordSerializerOptions(this.maskedLinks, this.escapeMarkdown, (ComponentFlattener)((ComponentFlattener.Builder)this.flattener.toBuilder()).mapper(KeybindComponent.class, keybindProvider).build());
    }

    @Deprecated
    @NotNull
    public Function<TranslatableComponent, String> getTranslationProvider() {
        return component -> "";
    }

    @Deprecated
    public DiscordSerializerOptions withTranslationProvider(Function<TranslatableComponent, String> translationProvider) {
        return new DiscordSerializerOptions(this.maskedLinks, this.escapeMarkdown, (ComponentFlattener)((ComponentFlattener.Builder)this.flattener.toBuilder()).mapper(TranslatableComponent.class, translationProvider).build());
    }

    public String toString() {
        return "DiscordSerializerOptions{maskedLinks=" + this.maskedLinks + ", escapeMarkdown=" + this.escapeMarkdown + ", flattener=" + this.flattener + '}';
    }
}

