/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.common.event;

import fi.fabianadrian.webhooklogger.common.WebhookLogger;
import fi.fabianadrian.webhooklogger.common.config.MainConfig;
import fi.fabianadrian.webhooklogger.common.dependency.Dependency;
import fi.fabianadrian.webhooklogger.common.platform.PlatformPlayer;
import io.github.miniplaceholders.api.MiniPlaceholders;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public final class PlaceholderFactory {
    private final WebhookLogger webhookLogger;
    private final MainConfig.PlaceholderConfig config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public PlaceholderFactory(WebhookLogger webhookLogger) {
        this.webhookLogger = webhookLogger;
        this.config = webhookLogger.mainConfig().placeholders();
    }

    public TagResolver timestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.config.timestampFormat()).withZone(this.config.timestampTimezone());
        return Placeholder.unparsed((String)"timestamp", (String)formatter.format(Instant.now()));
    }

    public TagResolver cancelled(boolean cancelled) {
        String cancelledString = cancelled ? this.config.cancelled() : "";
        return Placeholder.unparsed((String)"cancelled", (String)cancelledString);
    }

    public TagResolver player(PlatformPlayer player) {
        ArrayList<Object> resolvers = new ArrayList<Object>();
        resolvers.add(this.audience((Audience)player));
        String address = String.valueOf(player.address());
        resolvers.add(Placeholder.unparsed((String)"address", (String)address));
        Component location = this.miniMessage.deserialize(this.config.locationFormat(), player.location().tagResolver());
        resolvers.add(Placeholder.component((String)"location", (ComponentLike)location));
        return TagResolver.resolver(resolvers);
    }

    public TagResolver audience(Audience audience) {
        ArrayList<Object> resolvers = new ArrayList<Object>();
        String name = (String)audience.getOrDefault(Identity.NAME, (Object)"unknown");
        resolvers.add(Placeholder.unparsed((String)"name", (String)name));
        Component displayName = (Component)audience.getOrDefault(Identity.DISPLAY_NAME, (Object)Component.text((String)name));
        resolvers.add(Placeholder.component((String)"display_name", (ComponentLike)displayName));
        String uuid = audience.get(Identity.UUID).map(UUID::toString).orElse("unknown");
        resolvers.add(Placeholder.unparsed((String)"uuid", (String)uuid));
        if (this.webhookLogger.dependencyManager().isPresent(Dependency.MINI_PLACEHOLDERS)) {
            resolvers.add(MiniPlaceholders.audienceGlobalPlaceholders());
        }
        return TagResolver.resolver(resolvers);
    }

    public TagResolver message(Component message) {
        if (message == null) {
            return Placeholder.unparsed((String)"message", (String)"");
        }
        return Placeholder.component((String)"message", (ComponentLike)message);
    }

    public TagResolver command(String command) {
        if (!((String)command).startsWith("/")) {
            command = "/" + (String)command;
        }
        return Placeholder.unparsed((String)"command", (String)command);
    }
}

