/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.list.sorting;

import fi.fabianadrian.playerlist.list.sorting.Sorter;
import fi.fabianadrian.playerlist.list.sorting.SorterType;
import fi.fabianadrian.playerlist.list.sorting.SortingOrder;
import java.util.Comparator;
import java.util.Iterator;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import org.bukkit.entity.Player;

public final class LuckPermsSorter
extends Sorter {
    private final Criteria criteria;
    private LuckPerms api = null;

    public LuckPermsSorter(SortingOrder order, Criteria criteria) {
        super(SorterType.LUCKPERMS, order);
        this.comparator = Comparator.comparingInt(this::weight);
        this.criteria = criteria;
        try {
            this.api = LuckPermsProvider.get();
        }
        catch (IllegalStateException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    public Criteria criteria() {
        return this.criteria;
    }

    private int weight(Player player) {
        if (this.api == null) {
            return 0;
        }
        return switch (this.criteria.ordinal()) {
            case 0 -> this.highestPrefixWeight(player);
            case 1 -> this.highestSuffixWeight(player);
            case 2 -> this.primaryGroupWeight(player);
            default -> throw new IllegalStateException("Unknown criteria");
        };
    }

    private int highestPrefixWeight(Player player) {
        User user = this.user(player);
        Iterator prefixWeights = user.getCachedData().getMetaData().getPrefixes().keySet().iterator();
        int highestWeight = 0;
        if (prefixWeights.hasNext()) {
            highestWeight = (Integer)prefixWeights.next();
        }
        return highestWeight;
    }

    private int highestSuffixWeight(Player player) {
        User user = this.user(player);
        Iterator weights = user.getCachedData().getMetaData().getSuffixes().keySet().iterator();
        int highestWeight = 0;
        if (weights.hasNext()) {
            highestWeight = (Integer)weights.next();
        }
        return highestWeight;
    }

    private int primaryGroupWeight(Player player) {
        User user = this.user(player);
        String primaryGroupName = user.getPrimaryGroup();
        Group primaryGroup = this.api.getGroupManager().getGroup(primaryGroupName);
        if (primaryGroup == null) {
            return 0;
        }
        return primaryGroup.getWeight().orElse(0);
    }

    private User user(Player player) {
        return this.api.getPlayerAdapter(Player.class).getUser((Object)player);
    }

    public static enum Criteria {
        PREFIX_WEIGHT,
        SUFFIX_WEIGHT,
        GROUP_WEIGHT;

    }
}

