/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.configuration.serializer;

import fi.fabianadrian.playerlist.PlayerList;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.ConfigurationNode;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize.SerializationException;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize.TypeSerializer;
import fi.fabianadrian.playerlist.list.sorting.LuckPermsSorter;
import fi.fabianadrian.playerlist.list.sorting.PlaceholderSorter;
import fi.fabianadrian.playerlist.list.sorting.Sorter;
import fi.fabianadrian.playerlist.list.sorting.SorterType;
import fi.fabianadrian.playerlist.list.sorting.SortingOrder;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SorterSerializer
implements TypeSerializer<Sorter> {
    private static final String TYPE = "type";
    private static final String ORDER = "order";
    private static final String CRITERIA = "criteria";
    private static final String PLACEHOLDER = "placeholder";
    private static final String CASE_SENSITIVE = "case-sensitive";
    private final PlayerList plugin;

    public SorterSerializer(PlayerList plugin) {
        this.plugin = plugin;
    }

    @Override
    public Sorter deserialize(Type type, ConfigurationNode node) throws SerializationException {
        ConfigurationNode typeNode = this.nonVirtualNode(node, TYPE);
        SorterType sorterType = typeNode.get(SorterType.class);
        ConfigurationNode orderNode = this.nonVirtualNode(node, ORDER);
        SortingOrder order = orderNode.get(SortingOrder.class);
        switch (sorterType) {
            case LUCKPERMS: {
                ConfigurationNode criteriaNode = this.nonVirtualNode(node, CRITERIA);
                LuckPermsSorter.Criteria criteria = criteriaNode.get(LuckPermsSorter.Criteria.class);
                return new LuckPermsSorter(order, criteria);
            }
            case PLACEHOLDER: {
                ConfigurationNode placeholderNode = this.nonVirtualNode(node, PLACEHOLDER);
                String placeholder = placeholderNode.getString();
                Boolean caseSensitive = node.node(CASE_SENSITIVE).getBoolean(true);
                return new PlaceholderSorter(this.plugin, order, placeholder, caseSensitive);
            }
        }
        throw new IllegalStateException("Unknown sorter type");
    }

    @Override
    public void serialize(Type type, @Nullable Sorter sorter, ConfigurationNode node) throws SerializationException {
        if (sorter == null) {
            node.raw(null);
            return;
        }
        node.node(TYPE).set((Object)sorter.type());
        node.node(ORDER).set((Object)sorter.order());
        if (sorter instanceof LuckPermsSorter) {
            LuckPermsSorter luckPermsSorter = (LuckPermsSorter)sorter;
            node.node(CRITERIA).set((Object)luckPermsSorter.criteria());
        } else if (sorter instanceof PlaceholderSorter) {
            PlaceholderSorter placeholderSorter = (PlaceholderSorter)sorter;
            node.node(PLACEHOLDER).set(placeholderSorter.placeholder());
            node.node(CASE_SENSITIVE).set(placeholderSorter.caseSensitive());
        }
    }

    private ConfigurationNode nonVirtualNode(ConfigurationNode source, Object ... path) throws SerializationException {
        if (!source.hasChild(path)) {
            throw new SerializationException("Required field " + Arrays.toString(path) + " was not present in node");
        }
        return source.node(path);
    }
}

