/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.world.display;

import fi.fabianadrian.nightaccelerator.NightAccelerator;
import fi.fabianadrian.nightaccelerator.config.section.TitleSection;
import fi.fabianadrian.nightaccelerator.tagresolver.TagResolverFactory;
import fi.fabianadrian.nightaccelerator.world.SleepWorld;
import fi.fabianadrian.nightaccelerator.world.display.Display;
import java.time.Duration;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;

public final class TitleDisplay
implements Display {
    private static final Title.Times TIMES = Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L));
    private final SleepWorld world;
    private final TitleSection config;
    private final TagResolverFactory resolverFactory;

    public TitleDisplay(NightAccelerator plugin, SleepWorld world) {
        this.world = world;
        this.config = plugin.config().display().title();
        this.resolverFactory = plugin.resolverFactory();
    }

    @Override
    public void update() {
        this.sendTitle(this.config.sleepingTitle(), this.config.sleepingSubtitle());
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void morning() {
        this.sendTitle(this.config.morningTitle(), this.config.morningSubtitle());
    }

    private void sendTitle(String titleString, String subtitleString) {
        this.world.sleeping().forEach(player -> {
            TagResolver tagResolver = this.resolverFactory.resolver(this.world);
            Component title = NightAccelerator.MINI_MESSAGE.deserialize(titleString, (Pointered)player, tagResolver);
            Component subtitle = NightAccelerator.MINI_MESSAGE.deserialize(subtitleString, (Pointered)player, tagResolver);
            player.sendTitlePart(TitlePart.TIMES, (Object)TIMES);
            player.sendTitlePart(TitlePart.TITLE, (Object)title);
            player.sendTitlePart(TitlePart.SUBTITLE, (Object)subtitle);
        });
    }
}

