/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.world.acceleration;

import fi.fabianadrian.nightaccelerator.NightAccelerator;
import fi.fabianadrian.nightaccelerator.config.section.AccelerationSection;
import fi.fabianadrian.nightaccelerator.world.SleepWorld;
import fi.fabianadrian.nightaccelerator.world.acceleration.AccelerateTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public final class AccelerationManager {
    private final SleepWorld sleepWorld;
    private final BukkitScheduler scheduler = Bukkit.getScheduler();
    private final NightAccelerator plugin;
    private final AccelerateTask accelerateTask;
    private BukkitTask bukkitTask;

    public AccelerationManager(NightAccelerator plugin, SleepWorld sleepWorld) {
        this.plugin = plugin;
        this.sleepWorld = sleepWorld;
        this.accelerateTask = new AccelerateTask(sleepWorld.world());
    }

    public void recalculate() {
        if (this.sleepWorld.sleeping().isEmpty()) {
            if (this.bukkitTask != null) {
                this.bukkitTask.cancel();
                this.bukkitTask = null;
            }
            return;
        }
        AccelerationSection config = this.plugin.config().acceleration();
        double sleepingPlayersRatio = (double)this.sleepWorld.sleeping().size() / (double)this.sleepWorld.max();
        long ticksToAdd = (long)this.interpolate(config.min(), config.max(), sleepingPlayersRatio, config.factor());
        this.accelerateTask.ticksToAdd(ticksToAdd);
        if (this.bukkitTask == null) {
            this.bukkitTask = this.scheduler.runTaskTimer((Plugin)this.plugin, (Runnable)this.accelerateTask, 0L, (long)config.updateRate());
        }
    }

    public void shutdown() {
        if (this.bukkitTask != null) {
            this.bukkitTask.cancel();
        }
    }

    private double interpolate(double min, double max, double normalizedValue, double curveFactor) {
        if (curveFactor == 0.0) {
            return min + (max - min) * normalizedValue;
        }
        double adjustedValue = curveFactor > 0.0 ? Math.pow(normalizedValue, 1.0 + curveFactor) : 1.0 - Math.pow(1.0 - normalizedValue, 1.0 - curveFactor);
        return min + (max - min) * adjustedValue;
    }
}

