/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.world;

import fi.fabianadrian.nightaccelerator.NightAccelerator;
import fi.fabianadrian.nightaccelerator.world.SleepWorld;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class WorldManager {
    private final NightAccelerator plugin;
    private final Map<UUID, SleepWorld> worlds = new HashMap<UUID, SleepWorld>();
    private final Set<UUID> recalculationsQueued = new HashSet<UUID>();

    public WorldManager(NightAccelerator plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.worlds.values().forEach(SleepWorld::shutdown);
        this.worlds.clear();
        this.recalculationsQueued.clear();
        List<String> enabledWorlds = this.plugin.config().enabledWorlds();
        enabledWorlds.forEach(worldName -> {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                this.plugin.getSLF4JLogger().warn("Please check configuration! Couldn't find a world named {}", worldName);
                return;
            }
            SleepWorld sleepWorld = new SleepWorld(this.plugin, world);
            sleepWorld.recalculate();
            this.worlds.put(world.getUID(), sleepWorld);
        });
    }

    public SleepWorld world(UUID uuid) {
        return this.worlds.get(uuid);
    }

    public SleepWorld world(Player player) {
        return this.world(player.getWorld().getUID());
    }

    public void recalculate(World world) {
        SleepWorld sleepWorld = this.worlds.get(world.getUID());
        if (sleepWorld == null) {
            return;
        }
        if (!this.recalculationsQueued.add(world.getUID())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            sleepWorld.recalculate();
            this.recalculationsQueued.remove(world.getUID());
        }, 1L);
    }
}

