/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.tagresolver;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PointeredResolver
implements TagResolver {
    private static final List<String> TAGS = List.of("name", "display_name", "uuid");

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        Pointered pointered = ctx.target();
        if (pointered == null) {
            return null;
        }
        switch (name.toLowerCase(Locale.ROOT)) {
            case "name": {
                return Tag.preProcessParsed((String)((String)pointered.getOrDefault(Identity.NAME, (Object)"unknown")));
            }
            case "display_name": {
                return Tag.selfClosingInserting((Component)((Component)pointered.getOrDefault(Identity.DISPLAY_NAME, (Object)Component.text((String)"unknown"))));
            }
            case "uuid": {
                UUID uuid = (UUID)pointered.getOrDefault(Identity.UUID, null);
                String uuidAsString = uuid == null ? "unknown" : uuid.toString();
                return Tag.preProcessParsed((String)uuidAsString);
            }
        }
        return null;
    }

    public boolean has(@NotNull String name) {
        return TAGS.contains(name.toLowerCase(Locale.ROOT));
    }
}

