/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.GenericContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class TypeToken<V> {
    private final @NonNull ReifiedType.Annotated reifiedType;

    public TypeToken(@NonNull ReifiedType.Annotated reifiedType) {
        this.reifiedType = Objects.requireNonNull(reifiedType);
    }

    protected TypeToken() {
        AnnotatedType typeFromSubclass = this.extractTypeFromSubclass();
        this.reifiedType = new GenericContext(ReifiedType.Annotated.unannotated(Object.class)){

            @Override
            ReifiedType.Annotated unknownVariable(String varName) {
                throw new DeveloperMistakeException("Type variables are rejected in TypeToken construction. Found variable '" + varName + '\'');
            }
        }.reify(typeFromSubclass);
    }

    public final @PolyNull V cast(@PolyNull Object obj) {
        Class<V> rawType = this.getRawType();
        if (rawType.isPrimitive()) {
            TypeDescriptor.OfField wrapperType = MethodType.methodType(rawType).wrap().returnType();
            return (V)((Class)wrapperType).cast(obj);
        }
        return rawType.cast(obj);
    }

    public final @NonNull Class<V> getRawType() {
        Class<?> rawType = this.reifiedType.rawType();
        return rawType;
    }

    public final @NonNull ReifiedType.Annotated getReifiedType() {
        return this.reifiedType;
    }

    private @NonNull AnnotatedType extractTypeFromSubclass() {
        AnnotatedType superClassType = this.getClass().getAnnotatedSuperclass();
        if (!(superClassType instanceof AnnotatedParameterizedType)) {
            throw new DeveloperMistakeException("Invalid TypeToken. Must subclass and specify generic arguments.");
        }
        return ((AnnotatedParameterizedType)superClassType).getAnnotatedActualTypeArguments()[0];
    }

    public final boolean equals(Object o) {
        if (!(o instanceof TypeToken)) {
            return false;
        }
        TypeToken typeToken = (TypeToken)o;
        return this.reifiedType.equals(typeToken.reifiedType);
    }

    public final int hashCode() {
        return this.reifiedType.hashCode();
    }

    public final String toString() {
        return "TypeToken{" + this.reifiedType + '}';
    }
}

