/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Utilities;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerRange;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ReifiedTypeTest {
    private final Class<?> listClass = List.class;
    private final Class<?> mapClass = Map.class;
    private final Class<String> stringClass = String.class;
    private final Class<Object> objectClass = Object.class;
    private final Class<?> type = this.listClass;
    private final ReifiedType[] params = new ReifiedType[]{new ReifiedType(this.mapClass, new ReifiedType[]{new ReifiedType(this.stringClass, ReifiedType.Annotated.EMPTY_ARRAY), new ReifiedType(this.objectClass, ReifiedType.Annotated.EMPTY_ARRAY)})};

    @Test
    public void construct() {
        ReifiedType sample = new ReifiedType(this.type, this.params);
        Assertions.assertEquals(this.type, sample.rawType());
        Assertions.assertArrayEquals((Object[])this.params, (Object[])sample.arguments());
        Assertions.assertEquals((int)1, (int)sample.argumentCount());
        Assertions.assertEquals((Object)this.params[0], (Object)sample.argumentAt(0));
    }

    @Test
    public void equality() {
        ReifiedType sample = new ReifiedType(this.type, this.params);
        Utilities.assertEqualsBothWays(sample, sample);
        Utilities.assertEqualsBothWays(new ReifiedType(this.type, this.params), sample);
        Utilities.assertNotEqualsBothWays(new ReifiedType(this.type, ReifiedType.Annotated.EMPTY_ARRAY), sample);
        Utilities.assertEqualsBothWays(ReifiedType.Annotated.unannotated(this.objectClass), sample.argumentAt(0).argumentAt(1));
    }

    @Test
    public void toStringTest() {
        ReifiedType sample = new ReifiedType(this.type, this.params);
        Assertions.assertTrue((boolean)sample.toString().contains("List"));
        Assertions.assertTrue((boolean)sample.toString().contains("Map"));
    }

    @Nested
    public class AnnotatedTest {
        private final Class<Nullable> nullableClass = Nullable.class;
        private final AnnotatedElement annotatedNullable = AnnotatedTest.class.getDeclaredMethod("annotatedNullable", new Class[0]).getAnnotatedReturnType();
        private final Class<NonNull> nonNullClass = NonNull.class;
        private final AnnotatedElement annotatedNonNull = AnnotatedTest.class.getDeclaredMethod("annotatedNonNull", new Class[0]).getAnnotatedReturnType();
        private final ReifiedType.Annotated[] annotatedParams;

        @Nullable Object annotatedNullable() {
            return null;
        }

        @NonNull Object annotatedNonNull() {
            return new Object();
        }

        public AnnotatedTest() throws NoSuchMethodException {
            this.annotatedParams = new ReifiedType.Annotated[]{new ReifiedType.Annotated(ReifiedTypeTest.this.mapClass, new ReifiedType.Annotated[]{ReifiedType.Annotated.unannotated(ReifiedTypeTest.this.stringClass), new ReifiedType.Annotated(ReifiedTypeTest.this.objectClass, ReifiedType.Annotated.EMPTY_ARRAY, this.annotatedNonNull)}, ReifiedType.Annotated.unannotated())};
        }

        @Test
        public void annotations(@Mock AnnotatedElement annotations) {
            ReifiedType.Annotated sample = new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, this.annotatedNullable);
            Assertions.assertTrue((boolean)sample.isAnnotationPresent(Nullable.class));
            Assertions.assertFalse((boolean)sample.isAnnotationPresent(IntegerRange.class));
            Assertions.assertFalse((boolean)sample.isAnnotationPresent(NonNull.class));
            Assertions.assertNotNull((Object)sample.getAnnotation(Nullable.class));
            Assertions.assertNull((Object)sample.getAnnotation(NonNull.class));
            Assertions.assertArrayEquals((Object[])new Annotation[0], (Object[])sample.getAnnotationsByType(NonNull.class));
            Assertions.assertEquals((int)1, (int)((Nullable[])sample.getAnnotationsByType(Nullable.class)).length);
            Assertions.assertEquals((int)1, (int)sample.getAnnotations().length);
            Assertions.assertNotNull((Object)sample.getDeclaredAnnotation(Nullable.class));
            Assertions.assertNull((Object)sample.getDeclaredAnnotation(NonNull.class));
            Assertions.assertArrayEquals((Object[])new Annotation[0], (Object[])sample.getDeclaredAnnotationsByType(NonNull.class));
            Assertions.assertEquals((int)1, (int)((Nullable[])sample.getDeclaredAnnotationsByType(Nullable.class)).length);
            Assertions.assertEquals((int)1, (int)sample.getDeclaredAnnotations().length);
        }

        @Test
        public void equality() {
            ReifiedType.Annotated onlyArgsAnnotated = new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, ReifiedType.Annotated.unannotated());
            Utilities.assertEqualsBothWays(onlyArgsAnnotated, onlyArgsAnnotated);
            Utilities.assertEqualsBothWays(new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, ReifiedType.Annotated.unannotated()), onlyArgsAnnotated);
            Utilities.assertNotEqualsBothWays(new ReifiedType(ReifiedTypeTest.this.type, ReifiedTypeTest.this.params), onlyArgsAnnotated);
            ReifiedType.Annotated sample = new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, this.annotatedNullable);
            Utilities.assertEqualsBothWays(sample, sample);
            Utilities.assertEqualsBothWays(new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, this.annotatedNullable), sample);
            Utilities.assertNotEqualsBothWays(new ReifiedType(ReifiedTypeTest.this.type, ReifiedTypeTest.this.params), sample);
            Utilities.assertNotEqualsBothWays(onlyArgsAnnotated, sample);
        }

        @Test
        public void toStringTest() {
            ReifiedType.Annotated sample = new ReifiedType.Annotated(ReifiedTypeTest.this.type, this.annotatedParams, this.annotatedNullable);
            Assertions.assertTrue((boolean)sample.toString().contains("Nullable"));
        }
    }
}

