/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ReifiedType {
    private final @NonNull Class<?> rawType;
    private final @NonNull ReifiedType @NonNull [] arguments;

    public ReifiedType(@NonNull Class<?> rawType, @NonNull ReifiedType @NonNull [] arguments) {
        this.rawType = Objects.requireNonNull(rawType, "rawType");
        this.arguments = arguments == Annotated.EMPTY_ARRAY ? Annotated.EMPTY_ARRAY : (ReifiedType[])arguments.clone();
    }

    public @NonNull Class<?> rawType() {
        return this.rawType;
    }

    public @NonNull ReifiedType argumentAt(int index) {
        return this.arguments[index];
    }

    public int argumentCount() {
        return this.arguments.length;
    }

    public @NonNull ReifiedType @NonNull [] arguments() {
        return (ReifiedType[])this.arguments.clone();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ReifiedType)) {
            return false;
        }
        ReifiedType that = (ReifiedType)o;
        return this.rawType.equals(that.rawType) && Arrays.equals(this.arguments, that.arguments) && this.annotationsEq(that);
    }

    boolean annotationsEq(ReifiedType that) {
        if (that instanceof Annotated) {
            return ((Annotated)that).annotations.getAnnotations().length == 0;
        }
        return true;
    }

    public final int hashCode() {
        int result = this.rawType.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    void toString(StringBuilder builder) {
        this.toString(builder, null);
    }

    void toString(StringBuilder builder, AnnotatedElement annotations) {
        builder.append(this.rawType().getName());
        if (this.arguments.length != 0) {
            builder.append('<');
            for (int n = 0; n < this.arguments.length; ++n) {
                if (n != 0) {
                    builder.append(',');
                }
                this.arguments[n].toString(builder);
            }
            builder.append('>');
        }
        if (annotations != null) {
            for (Annotation annotation : annotations.getAnnotations()) {
                builder.append('@');
                builder.append(annotation.annotationType().getName());
            }
        }
    }

    public static final class Annotated
    extends ReifiedType
    implements AnnotatedElement {
        private final AnnotatedElement annotations;
        public static final Annotated[] EMPTY_ARRAY = new Annotated[0];

        public Annotated(@NonNull Class<?> rawType, @NonNull Annotated @NonNull [] arguments, @NonNull AnnotatedElement annotations) {
            super(rawType, arguments);
            this.annotations = Objects.requireNonNull(annotations, "annotations");
        }

        public static @NonNull Annotated unannotated(@NonNull Class<?> rawType) {
            return new Annotated(rawType, EMPTY_ARRAY, Void.TYPE);
        }

        public static AnnotatedElement unannotated() {
            return Void.TYPE;
        }

        @Override
        public @NonNull Annotated argumentAt(int index) {
            return (Annotated)super.argumentAt(index);
        }

        public @NonNull Annotated @NonNull [] arguments() {
            return (Annotated[])super.arguments();
        }

        @Override
        boolean annotationsEq(ReifiedType that) {
            if (that instanceof Annotated) {
                Annotation[] theirs;
                Annotated thatAnnotated = (Annotated)that;
                Annotation[] ours = this.annotations.getAnnotations();
                if (ours.length != (theirs = thatAnnotated.annotations.getAnnotations()).length) {
                    return false;
                }
                for (Annotation ourAnnote : ours) {
                    Annotation theirAnnote = thatAnnotated.getAnnotation(ourAnnote.annotationType());
                    if (ourAnnote.equals(theirAnnote)) continue;
                    return false;
                }
                return true;
            }
            return this.annotations.getAnnotations().length == 0;
        }

        @Override
        void toString(StringBuilder builder) {
            this.toString(builder, this.annotations);
        }

        @Override
        public boolean isAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
            return this.annotations.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(@NonNull Class<T> annotationClass) {
            return this.annotations.getAnnotation(annotationClass);
        }

        @Override
        public Annotation @NonNull [] getAnnotations() {
            return this.annotations.getAnnotations();
        }

        @Override
        public <T extends Annotation> T @NonNull [] getAnnotationsByType(@NonNull Class<T> annotationClass) {
            return this.annotations.getAnnotationsByType(annotationClass);
        }

        @Override
        public <T extends Annotation> T getDeclaredAnnotation(@NonNull Class<T> annotationClass) {
            return this.annotations.getDeclaredAnnotation(annotationClass);
        }

        @Override
        public <T extends Annotation> T @NonNull [] getDeclaredAnnotationsByType(@NonNull Class<T> annotationClass) {
            return this.annotations.getDeclaredAnnotationsByType(annotationClass);
        }

        @Override
        public Annotation @NonNull [] getDeclaredAnnotations() {
            return this.annotations.getDeclaredAnnotations();
        }
    }
}

