/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ReloadShell;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Utilities;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.Instantiator;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodYield;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class ReflectionServiceTest {
    private final Instantiator instantiator;
    private final MethodMirror methodMirror;

    protected ReflectionServiceTest(ReflectionService reflectionService) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.instantiator = reflectionService.makeInstantiator(lookup);
        this.methodMirror = reflectionService.makeMethodMirror(lookup);
    }

    @Nested
    public class MirrorTest {
        private MethodId hello;
        private MethodId overidden;
        private MethodId anotherCall;
        private MethodId giveBack;
        private MethodId checkReflection;
        private MethodId giveArray;

        private void setField(MethodId methodId) {
            switch (methodId.name()) {
                case "hello": {
                    this.hello = methodId;
                    break;
                }
                case "overidden": {
                    if (this.overidden != null) break;
                    this.overidden = methodId;
                    break;
                }
                case "anotherCall": {
                    this.anotherCall = methodId;
                    break;
                }
                case "giveBack": {
                    this.giveBack = methodId;
                    break;
                }
                case "checkReflection": {
                    this.checkReflection = methodId;
                    break;
                }
                case "giveArray": {
                    this.giveArray = methodId;
                }
            }
        }

        @BeforeEach
        public void setupMethods() {
            MethodMirror.TypeWalker baseWalker = ReflectionServiceTest.this.methodMirror.typeWalker(new TypeToken<Base>(this){}.getReifiedType());
            baseWalker.getViableMethods().forEach(this::setField);
            MethodMirror.TypeWalker midLevelWalker = baseWalker.getSuperTypes()[0];
            midLevelWalker.getViableMethods().forEach(this::setField);
            MethodMirror.TypeWalker parentWalker = midLevelWalker.getSuperTypes()[0];
            parentWalker.getViableMethods().forEach(this::setField);
        }

        @Test
        public void typeWalker() {
            ReifiedType.Annotated baseType = new TypeToken<Base>(this){}.getReifiedType();
            MethodMirror.TypeWalker baseWalker = ReflectionServiceTest.this.methodMirror.typeWalker(baseType);
            Assertions.assertEquals((Object)baseType, (Object)baseWalker.getEnclosingType(), (String)"Return correct getEnclosingType()");
            Assertions.assertEquals(Set.of(this.anotherCall, this.giveBack, this.checkReflection, this.giveArray), baseWalker.getViableMethods().collect(Collectors.toSet()), (String)"Returns correct getViableMethods()");
            Set<MethodId> expectedData = Set.of(new MethodId("anotherCall", ReifiedType.Annotated.unannotated(Void.TYPE), new ReifiedType[0], false), new MethodId("giveBack", new TypeToken<Object>(this){}.getReifiedType(), new ReifiedType[]{new TypeToken<Supplier<Object>>(this){}.getReifiedType()}, true), new MethodId("checkReflection", ReifiedType.Annotated.unannotated(Void.TYPE), new ReifiedType[]{new TypeToken<Consumer<Object>>(this){}.getReifiedType()}, true), new MethodId("giveArray", new TypeToken<String[]>(this){}.getReifiedType(), new ReifiedType[0], true));
            Assertions.assertEquals(expectedData, Set.of(this.anotherCall, this.giveBack, this.checkReflection, this.giveArray));
            MethodMirror.TypeWalker[] superTypes = baseWalker.getSuperTypes();
            Assertions.assertEquals((int)1, (int)superTypes.length, (String)"Return correct getSuperTypes()");
            MethodMirror.TypeWalker midWalker = superTypes[0];
            Assertions.assertNotNull((Object)midWalker, (String)"Return correct getSuperTypes()");
            Assertions.assertEquals((Object)new TypeToken<MidLevel<String>>(this){}.getReifiedType(), (Object)midWalker.getEnclosingType(), (String)"Return correct getEnclosingType()");
            Set viableMethods = midWalker.getViableMethods().collect(Collectors.toSet());
            Assertions.assertEquals(Set.of(this.overidden), viableMethods, (String)"Returns correct getViableMethods()");
            AnnotatedElement overiddenMethodAnnotations = midWalker.getAnnotations(this.overidden);
            Assertions.assertFalse((boolean)overiddenMethodAnnotations.isAnnotationPresent(StringDefault.class), (String)"Returns annotations present on method");
            Comments seeMeComment = overiddenMethodAnnotations.getAnnotation(Comments.class);
            Assertions.assertNotNull((Object)seeMeComment, (String)"Returns annotations present on method");
            Assertions.assertArrayEquals((Object[])new String[]{"see me"}, (Object[])seeMeComment.value(), (String)"Returns annotations present on method");
            MethodMirror.TypeWalker[] superTypes2 = midWalker.getSuperTypes();
            Assertions.assertEquals((int)1, (int)superTypes2.length, (String)"Return correct getSuperTypes()");
            MethodMirror.TypeWalker parentWalker = superTypes2[0];
            Assertions.assertNotNull((Object)parentWalker, (String)"Return correct getSuperTypes()");
            Assertions.assertEquals((Object)new TypeToken<Parent<String>>(this){}.getReifiedType(), (Object)parentWalker.getEnclosingType(), (String)"Return correct getEnclosingType()");
        }

        @Test
        public void makeInvoker() {
            final AtomicBoolean anotherCallHook = new AtomicBoolean();
            final AtomicInteger helloHook = new AtomicInteger();
            final String[] presetArray = new String[]{"truly", "preset"};
            Base base = new Base(){

                @Override
                public void anotherCall() {
                    if (!anotherCallHook.compareAndSet(false, true)) {
                        throw new IllegalStateException();
                    }
                }

                @Override
                public int hello() {
                    return helloHook.getAndIncrement();
                }

                @Override
                public String[] giveArray() {
                    return presetArray;
                }
            };
            MethodMirror.Invoker invokeBase = ReflectionServiceTest.this.methodMirror.makeInvoker(base, Base.class);
            Assertions.assertDoesNotThrow(() -> invokeBase.invokeMethod(this.anotherCall, new Object[0]), (String)"Calls method via MethodInvoker#invokeMethod and uses correct implementation");
            Assertions.assertTrue((boolean)anotherCallHook.get(), (String)"Calls method via MethodInvoker#invokeMethod and uses correct implementation");
            Assertions.assertThrows(InvocationTargetException.class, () -> invokeBase.invokeMethod(this.anotherCall, new Object[0]), (String)"Catches exception when thrown by method via MethodInvoker#invokeMethod and wraps in InvocationTargetException");
            try {
                invokeBase.invokeMethod(this.anotherCall, new Object[0]);
            }
            catch (InvocationTargetException caught) {
                Assertions.assertInstanceOf(IllegalStateException.class, (Object)caught.getCause(), (String)"Catches exception when thrown by method via MethodInvoker#invokeMethod and wraps in InvocationTargetException");
            }
            Object invokeGiveBack = Assertions.assertDoesNotThrow(() -> invokeBase.invokeMethod(this.giveBack, () -> true), (String)"Calls default method via MethodInvoker#invokeMethod, and uses default implementation");
            Assertions.assertEquals((Object)true, (Object)invokeGiveBack);
            Object invokeGiveArray = Assertions.assertDoesNotThrow(() -> invokeBase.invokeMethod(this.giveArray, new Object[0]), (String)"Calls overidden (originally default) method via MethodInvoker#invokeMethod, and uses overidden implementation");
            Assertions.assertSame((Object)presetArray, (Object)invokeGiveArray);
            MethodMirror.Invoker invokeParent = ReflectionServiceTest.this.methodMirror.makeInvoker(base, Parent.class);
            Assertions.assertEquals((Object)0, (Object)Assertions.assertDoesNotThrow(() -> invokeParent.invokeMethod(this.hello, new Object[0])), (String)"Calls method in parent class via MethodInvoker#invokeMethod using correct invoker");
            Assertions.assertEquals((Object)1, (Object)Assertions.assertDoesNotThrow(() -> invokeParent.invokeMethod(this.hello, new Object[0])), (String)"Calls method in parent class via MethodInvoker#invokeMethod using correct invoker");
            Assertions.assertEquals((int)2, (int)helloHook.get());
            AtomicBoolean checkReflectionOutcome = new AtomicBoolean();
            Consumer<Boolean> checkReflection = checkReflectionOutcome::set;
            Base generatedBase = ReflectionServiceTest.this.instantiator.generateEmpty(Base.class);
            MethodMirror.Invoker invokeGeneratedBase = ReflectionServiceTest.this.methodMirror.makeInvoker(generatedBase, Base.class);
            generatedBase.checkReflection(checkReflection);
            Assertions.assertFalse((boolean)checkReflectionOutcome.get(), (String)"Test setup: Not called with reflection");
            try {
                Base.class.getDeclaredMethod("checkReflection", Consumer.class).invoke((Object)generatedBase, checkReflection);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new AssertionError("Calling problem", ex);
            }
            Assertions.assertTrue((boolean)checkReflectionOutcome.get(), (String)"Test setup: Called with reflection");
            try {
                invokeGeneratedBase.invokeMethod(this.checkReflection, checkReflection);
            }
            catch (InvocationTargetException ex) {
                throw new AssertionError("Calling problem", ex);
            }
            Assertions.assertFalse((boolean)checkReflectionOutcome.get(), (String)"Calling method via MethodInvoker#invokeMethod should not use standard reflection if called upon a proxy");
        }

        public static interface Base
        extends MidLevel<String> {
            public void anotherCall();

            default public <V> V giveBack(Supplier<V> supplier) {
                return supplier.get();
            }

            default public void checkReflection(Consumer<? super Boolean> checkReflection) {
                boolean detectedCall = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_REFLECT_FRAMES)).walk(frameStream -> frameStream.takeWhile(frame -> !frame.getMethodName().equals("makeInvoker")).anyMatch(frame -> frame.getDeclaringClass().equals(Method.class)));
                checkReflection.accept((Boolean)detectedCall);
            }

            default public String[] giveArray() {
                return new String[0];
            }

            public static Comparable<String> staticIgnore() {
                return "static ignore";
            }
        }

        public static interface Parent<V> {
            public int hello();

            public List<V> overidden();
        }

        public static interface MidLevel<V>
        extends Parent<V> {
            @Override
            @Comments(value={"see me"})
            default public List<V> overidden() {
                return List.of();
            }
        }
    }

    @Nested
    public class InstantiatorTest {
        private final MethodId valueMethod;
        private final MethodId giveBackMethod;

        public InstantiatorTest() {
            this.valueMethod = ReflectionServiceTest.this.methodMirror.typeWalker(new TypeToken<SingleMethod>(this){}.getReifiedType()).getViableMethods().findAny().orElseThrow();
            this.giveBackMethod = ReflectionServiceTest.this.methodMirror.typeWalker(new TypeToken<PlusDefaultMethod>(this){}.getReifiedType()).getViableMethods().findAny().orElseThrow();
        }

        @Test
        public void generateEmptyInterface() {
            EmptyInterface generated = ReflectionServiceTest.this.instantiator.generate(EmptyInterface.class, new MethodYield());
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(EmptyInterface.class, (Object)generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(EmptyInterface.class, new MethodYield()));
        }

        @Test
        public void generateShellEmptyInterface() {
            ReloadShell<EmptyInterface> reloadShell = ReflectionServiceTest.this.instantiator.generateShell(EmptyInterface.class);
            Assertions.assertEquals(reloadShell, reloadShell);
            Assertions.assertNull((Object)reloadShell.getCurrentDelegate());
            EmptyInterface shell = reloadShell.getShell();
            Assertions.assertNotNull((Object)shell);
            Utilities.assertEqualsBothWays(shell, shell);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(shell));
            EmptyInterface delegate = new EmptyInterface(this){};
            Utilities.assertNotEqualsBothWays(delegate, shell);
            reloadShell.setCurrentDelegate(delegate);
            Utilities.assertEqualsBothWays(delegate, reloadShell.getCurrentDelegate());
            Utilities.assertNotEqualsBothWays(delegate, shell);
            Assertions.assertTrue((boolean)shell.toString().contains(delegate.toString()));
            Assertions.assertFalse((boolean)ReflectionServiceTest.this.instantiator.hasProduced(delegate));
            EmptyInterface shell2 = reloadShell.getShell();
            Assertions.assertSame((Object)shell, (Object)shell2, (String)"Shell stays constant");
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate(shell));
            ReloadShell<EmptyInterface> secondShell = ReflectionServiceTest.this.instantiator.generateShell(EmptyInterface.class);
            Utilities.assertNotEqualsBothWays(reloadShell, secondShell);
            Utilities.assertNotEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(delegate);
            Utilities.assertNotEqualsBothWays(shell, secondShell.getCurrentDelegate());
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(shell);
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate((EmptyInterface)secondShell.getShell()));
        }

        @Test
        public void generateEmptyEmptyInterface() {
            EmptyInterface generated = ReflectionServiceTest.this.instantiator.generateEmpty(EmptyInterface.class);
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(EmptyInterface.class, (Object)generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(EmptyInterface.class));
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(RandomAccess.class));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(EmptyInterface.class, new MethodYield()));
        }

        @Test
        public void generateSingleMethod() {
            String toReturn = "val1";
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, toReturn);
            }
            SingleMethod generated = ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, methodYield.copy());
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(SingleMethod.class, (Object)generated);
            Assertions.assertEquals((Object)toReturn, (Object)generated.value());
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, methodYield));
            Utilities.assertNotEqualsBothWays(generated, () -> toReturn);
            Assertions.assertTrue((boolean)generated.toString().contains(toReturn));
            MethodYield otherMethodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = otherMethodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, otherMethodYield));
        }

        @Test
        public void generateShellSingleMethod() {
            ReloadShell<SingleMethod> reloadShell = ReflectionServiceTest.this.instantiator.generateShell(SingleMethod.class);
            Assertions.assertEquals(reloadShell, reloadShell);
            Assertions.assertNull((Object)reloadShell.getCurrentDelegate());
            SingleMethod shell = reloadShell.getShell();
            Assertions.assertNotNull((Object)shell);
            Utilities.assertEqualsBothWays(shell, shell);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(shell));
            String toReturn = "delegated";
            SingleMethod mainDelegate = () -> toReturn;
            Utilities.assertNotEqualsBothWays(mainDelegate, shell);
            reloadShell.setCurrentDelegate(mainDelegate);
            Utilities.assertEqualsBothWays(mainDelegate, reloadShell.getCurrentDelegate());
            Utilities.assertNotEqualsBothWays(mainDelegate, shell);
            Assertions.assertEquals((Object)"delegated", (Object)shell.value());
            Assertions.assertTrue((boolean)shell.toString().contains(mainDelegate.toString()));
            Assertions.assertFalse((boolean)ReflectionServiceTest.this.instantiator.hasProduced(mainDelegate));
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate(shell));
            SingleMethod shellCopy = reloadShell.getShell();
            Assertions.assertSame((Object)shell, (Object)shellCopy, (String)"Shell stays constant");
            Assertions.assertEquals((Object)shell, (Object)shellCopy);
            IllegalStateException thrown = new IllegalStateException("Throw me");
            SingleMethod throwingDelegate = () -> {
                throw thrown;
            };
            reloadShell.setCurrentDelegate(throwingDelegate);
            try {
                shell.value();
                Assertions.fail((String)"Expected IllegalStateException to be thrown");
            }
            catch (IllegalStateException caught) {
                Assertions.assertSame((Object)thrown, (Object)caught);
            }
            ReloadShell<SingleMethod> secondShell = ReflectionServiceTest.this.instantiator.generateShell(SingleMethod.class);
            reloadShell.setCurrentDelegate(null);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            reloadShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertNotEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(shell);
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate((SingleMethod)secondShell.getShell()));
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(new MethodId("value", new TypeToken<String>(this){}.getReifiedType(), new ReifiedType[0], false), toReturn);
            }
            SingleMethod generated = ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, methodYield);
            reloadShell.setCurrentDelegate(null);
            Utilities.assertNotEqualsBothWays(generated, shell);
            reloadShell.setCurrentDelegate(generated);
            Utilities.assertEqualsBothWays(generated, shell);
        }

        @Test
        public void generateEmptySingleMethod() {
            SingleMethod generated = ReflectionServiceTest.this.instantiator.generateEmpty(SingleMethod.class);
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(SingleMethod.class, (Object)generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(SingleMethod.class));
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(EmptyInterface.class));
            MethodYield otherMethodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = otherMethodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, otherMethodYield));
            ReloadShell<SingleMethod> reloadShell = ReflectionServiceTest.this.instantiator.generateShell(SingleMethod.class);
            Utilities.assertNotEqualsBothWays(generated, reloadShell.getCurrentDelegate());
            reloadShell.setCurrentDelegate(generated);
            Utilities.assertEqualsBothWays(generated, reloadShell.getCurrentDelegate());
            reloadShell.setCurrentDelegate(ReflectionServiceTest.this.instantiator.generateEmpty(SingleMethod.class));
            Utilities.assertEqualsBothWays(generated, reloadShell.getCurrentDelegate());
        }

        @Test
        public void generateInheritedMethod() {
            String toReturn = "val1";
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, toReturn);
            }
            InheritedMethod generated = ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, methodYield.copy());
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(InheritedMethod.class, (Object)generated);
            Assertions.assertEquals((Object)toReturn, (Object)generated.value());
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, methodYield.copy()));
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(SingleMethod.class, methodYield));
            MethodYield otherMethodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = otherMethodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, otherMethodYield));
        }

        @Test
        public void generateShellInheritedMethod() {
            ReloadShell<InheritedMethod> reloadShell = ReflectionServiceTest.this.instantiator.generateShell(InheritedMethod.class);
            Assertions.assertEquals(reloadShell, reloadShell);
            Assertions.assertNull((Object)reloadShell.getCurrentDelegate());
            InheritedMethod shell = reloadShell.getShell();
            Assertions.assertNotNull((Object)shell);
            Utilities.assertEqualsBothWays(shell, shell);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(shell));
            String toReturn = "delegated";
            InheritedMethod mainDelegate = () -> toReturn;
            Utilities.assertNotEqualsBothWays(mainDelegate, shell);
            reloadShell.setCurrentDelegate(mainDelegate);
            Utilities.assertEqualsBothWays(mainDelegate, reloadShell.getCurrentDelegate());
            Utilities.assertNotEqualsBothWays(mainDelegate, shell);
            Assertions.assertEquals((Object)"delegated", (Object)shell.value());
            Assertions.assertTrue((boolean)shell.toString().contains(mainDelegate.toString()));
            Assertions.assertFalse((boolean)ReflectionServiceTest.this.instantiator.hasProduced(mainDelegate));
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate(shell));
            InheritedMethod shellCopy = reloadShell.getShell();
            Assertions.assertSame((Object)shell, (Object)shellCopy, (String)"Shell stays constant");
            Assertions.assertEquals((Object)shell, (Object)shellCopy);
            IllegalStateException thrown = new IllegalStateException("Throw me");
            InheritedMethod throwingDelegate = () -> {
                throw thrown;
            };
            reloadShell.setCurrentDelegate(throwingDelegate);
            try {
                shell.value();
                Assertions.fail((String)"Expected IllegalStateException to be thrown");
            }
            catch (IllegalStateException caught) {
                Assertions.assertSame((Object)thrown, (Object)caught);
            }
            ReloadShell<InheritedMethod> secondShell = ReflectionServiceTest.this.instantiator.generateShell(InheritedMethod.class);
            reloadShell.setCurrentDelegate(null);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            reloadShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertNotEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(shell);
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate((InheritedMethod)secondShell.getShell()));
            ReloadShell<SingleMethod> superShell = ReflectionServiceTest.this.instantiator.generateShell(SingleMethod.class);
            reloadShell.setCurrentDelegate(null);
            Assertions.assertNotEquals(reloadShell, superShell);
            Utilities.assertNotEqualsBothWays(shell, superShell.getShell());
            reloadShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, superShell);
            Utilities.assertNotEqualsBothWays(shell, superShell.getShell());
            superShell.setCurrentDelegate(mainDelegate);
            Assertions.assertNotEquals(reloadShell, superShell);
            Utilities.assertNotEqualsBothWays(shell, superShell.getShell());
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, toReturn);
            }
            InheritedMethod generated = ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, methodYield);
            reloadShell.setCurrentDelegate(null);
            Utilities.assertNotEqualsBothWays(generated, shell);
            reloadShell.setCurrentDelegate(mainDelegate);
            Utilities.assertNotEqualsBothWays(generated, shell);
            reloadShell.setCurrentDelegate(generated);
            Utilities.assertEqualsBothWays(generated, shell);
        }

        @Test
        public void generateEmptyInheritedMethod() {
            InheritedMethod generated = ReflectionServiceTest.this.instantiator.generateEmpty(InheritedMethod.class);
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(InheritedMethod.class, (Object)generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(InheritedMethod.class));
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(SingleMethod.class));
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, methodYield));
        }

        private void testGiveBack(PlusDefaultMethod plusDefaultMethod) {
            Assertions.assertEquals((Object)"hello", (Object)plusDefaultMethod.giveBack(() -> "hello"));
            Assertions.assertEquals((int)3, (Integer)plusDefaultMethod.giveBack(() -> 3));
        }

        @Test
        public void generatePlusDefaultMethod() {
            String toReturn = "val1";
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, toReturn);
            }
            methodYieldFor = methodYield.forImplementable(PlusDefaultMethod.class);
            try {
                methodYieldFor.callDefaultImpl(this.giveBackMethod);
            }
            finally {
                if (methodYieldFor != null) {
                    methodYieldFor.close();
                }
            }
            PlusDefaultMethod generated = ReflectionServiceTest.this.instantiator.generate(PlusDefaultMethod.class, methodYield.copy());
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(PlusDefaultMethod.class, (Object)generated);
            Assertions.assertEquals((Object)toReturn, (Object)generated.value());
            this.testGiveBack(generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(PlusDefaultMethod.class, methodYield.copy()));
            methodYield.clear();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, toReturn);
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(InheritedMethod.class, methodYield));
            MethodYield otherMethodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = otherMethodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            methodYieldFor = methodYield.forImplementable(PlusDefaultMethod.class);
            try {
                methodYieldFor.callDefaultImpl(this.giveBackMethod);
            }
            finally {
                if (methodYieldFor != null) {
                    methodYieldFor.close();
                }
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(PlusDefaultMethod.class, otherMethodYield));
        }

        @Test
        public void generateShellPlusDefaultMethod() {
            ReloadShell<PlusDefaultMethod> reloadShell = ReflectionServiceTest.this.instantiator.generateShell(PlusDefaultMethod.class);
            Assertions.assertEquals(reloadShell, reloadShell);
            Assertions.assertNull((Object)reloadShell.getCurrentDelegate());
            PlusDefaultMethod shell = reloadShell.getShell();
            Assertions.assertNotNull((Object)shell);
            Utilities.assertEqualsBothWays(shell, shell);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(shell));
            PlusDefaultMethod delegate = () -> "delegated";
            Utilities.assertNotEqualsBothWays(delegate, shell);
            reloadShell.setCurrentDelegate(delegate);
            Utilities.assertEqualsBothWays(delegate, reloadShell.getCurrentDelegate());
            Utilities.assertNotEqualsBothWays(delegate, shell);
            Assertions.assertEquals((Object)"delegated", (Object)shell.value());
            Assertions.assertTrue((boolean)shell.toString().contains(delegate.toString()));
            Assertions.assertFalse((boolean)ReflectionServiceTest.this.instantiator.hasProduced(delegate));
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate(shell));
            PlusDefaultMethod shellCopy = reloadShell.getShell();
            Assertions.assertSame((Object)shell, (Object)shellCopy, (String)"Shell stays constant");
            this.testGiveBack(shell);
            ReloadShell<PlusDefaultMethod> secondShell = ReflectionServiceTest.this.instantiator.generateShell(PlusDefaultMethod.class);
            reloadShell.setCurrentDelegate(null);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            reloadShell.setCurrentDelegate(delegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertNotEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(delegate);
            Assertions.assertNotEquals(reloadShell, secondShell);
            Utilities.assertEqualsBothWays(shell, secondShell.getShell());
            secondShell.setCurrentDelegate(shell);
            Assertions.assertThrows(IllegalArgumentException.class, () -> reloadShell.setCurrentDelegate((PlusDefaultMethod)secondShell.getShell()));
        }

        @Test
        public void generateEmptyPlusDefaultMethod() {
            PlusDefaultMethod generated = ReflectionServiceTest.this.instantiator.generateEmpty(PlusDefaultMethod.class);
            Assertions.assertNotNull((Object)generated);
            Assertions.assertInstanceOf(PlusDefaultMethod.class, (Object)generated);
            this.testGiveBack(generated);
            Assertions.assertTrue((boolean)ReflectionServiceTest.this.instantiator.hasProduced(generated));
            MethodYield methodYield = new MethodYield();
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(SingleMethod.class);){
                methodYieldFor.returnValue(this.valueMethod, "junk");
            }
            methodYieldFor = methodYield.forImplementable(PlusDefaultMethod.class);
            try {
                methodYieldFor.callDefaultImpl(this.giveBackMethod);
            }
            finally {
                if (methodYieldFor != null) {
                    methodYieldFor.close();
                }
            }
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generate(PlusDefaultMethod.class, methodYield));
            Utilities.assertEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(PlusDefaultMethod.class));
            Utilities.assertNotEqualsBothWays(generated, ReflectionServiceTest.this.instantiator.generateEmpty(SingleMethod.class));
        }

        public static interface EmptyInterface {
        }

        public static interface SingleMethod {
            public String value();
        }

        public static interface InheritedMethod
        extends SingleMethod {
        }

        public static interface PlusDefaultMethod
        extends InheritedMethod {
            default public <T> T giveBack(Supplier<T> what) {
                return what.get();
            }
        }
    }
}

