/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ReloadShell;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ProxyHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ProxyHandlerToDelegate<I>
extends ProxyHandler<I> {
    private volatile I delegate;
    private final MethodHandles.Lookup lookup;
    private volatile boolean needLookup;

    ProxyHandlerToDelegate(Class<I> iface, MethodHandles.Lookup lookup) {
        super(iface);
        this.lookup = lookup;
    }

    @Override
    Object implInvoke(Method method, Object[] args) throws Throwable {
        MethodHandle methodHandle;
        I delegate = this.delegate;
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        if (!this.needLookup) {
            try {
                return method.invoke(delegate, args);
            }
            catch (IllegalAccessException ex) {
                this.needLookup = true;
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw ex;
            }
        }
        try {
            methodHandle = this.lookup.unreflect(method);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        return methodHandle.bindTo(delegate).invokeWithArguments(args);
    }

    @Override
    boolean implEquals(Object ourProxy, Object otherProxy, ProxyHandler<?> otherHandler) {
        I delegate = this.delegate;
        if (otherHandler instanceof ProxyHandlerToDelegate) {
            ProxyHandlerToDelegate that = (ProxyHandlerToDelegate)otherHandler;
            return Objects.equals(delegate, that.delegate);
        }
        return delegate != null && delegate.equals(otherProxy);
    }

    @Override
    int implHashCode() {
        return Objects.hashCode(this.delegate);
    }

    @Override
    void implToString(StringBuilder output) {
        output.append(',').append("delegate").append('=').append(this.delegate);
    }

    class AsReloadShell
    implements ReloadShell<I> {
        private final I shell;

        AsReloadShell(I shell) {
            this.shell = shell;
        }

        @Override
        public void setCurrentDelegate(@Nullable I delegate) {
            this.checkNotShell(delegate);
            ProxyHandlerToDelegate.this.delegate = delegate;
        }

        private void checkNotShell(Object arg) {
            InvocationHandler argHandler;
            if (arg == null) {
                return;
            }
            if (this.shell == arg) {
                throw new IllegalArgumentException("Cannot set the delegate to the shell itself");
            }
            if (Proxy.isProxyClass(arg.getClass()) && (argHandler = Proxy.getInvocationHandler(arg)) instanceof ProxyHandlerToDelegate) {
                this.checkNotShell(((ProxyHandlerToDelegate)argHandler).delegate);
            }
        }

        @Override
        public @Nullable I getCurrentDelegate() {
            return ProxyHandlerToDelegate.this.delegate;
        }

        @Override
        public @NonNull I getShell() {
            return this.shell;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '{' + this.getCurrentDelegate() + '}';
        }
    }
}

