/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodYield;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MethodYieldTest {
    private final MethodId sample = new MethodId("sample", ReifiedType.Annotated.unannotated(String.class), new ReifiedType[0], false);

    public String sample() {
        return "sample";
    }

    @Test
    public void empty() {
        MethodYield methodYield = new MethodYield();
        Assertions.assertFalse((boolean)methodYield.entries().iterator().hasNext());
    }

    @Test
    public void addValue() {
        MethodYield methodYield = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "my value");
        }
        MethodYield.Entry entry = methodYield.entries().iterator().next();
        Assertions.assertEquals(MethodYieldTest.class, entry.implementable());
        Assertions.assertEquals((Object)this.sample, (Object)entry.method());
        Assertions.assertEquals((Object)"my value", (Object)entry.returnValue());
    }

    @Test
    public void clear() {
        MethodYield methodYield = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "my value");
        }
        methodYield.clear();
        Assertions.assertFalse((boolean)methodYield.entries().iterator().hasNext());
    }

    @Test
    public void copy() {
        MethodYield original = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = original.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "s");
        }
        MethodYield copy = original.copy();
        MethodYield.Entry entry = copy.entries().iterator().next();
        Assertions.assertEquals(MethodYieldTest.class, entry.implementable());
        Assertions.assertEquals((Object)this.sample, (Object)entry.method());
        Assertions.assertEquals((Object)"s", (Object)entry.returnValue());
    }

    @Test
    public void copyCannotMutate() {
        MethodYield original = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = original.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "s");
        }
        MethodYield copy = original.copy();
        Assertions.assertTrue((boolean)original.entries().iterator().hasNext());
        copy.clear();
        Assertions.assertTrue((boolean)original.entries().iterator().hasNext());
    }

    @Test
    public void copyCannotBeMutated() {
        MethodYield original = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = original.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "s");
        }
        MethodYield copy = original.copy();
        Assertions.assertTrue((boolean)copy.entries().iterator().hasNext());
        original.clear();
        Assertions.assertTrue((boolean)copy.entries().iterator().hasNext());
    }

    @Test
    public void equality() {
        EqualsVerifier.forClass(MethodYield.class).withPrefabValues(MethodId.class, (Object)this.sample, (Object)new MethodId("equality", ReifiedType.Annotated.unannotated(Void.TYPE), new ReifiedType[0], true)).withPrefabValues(ReifiedType[].class, (Object)ReifiedType.Annotated.EMPTY_ARRAY, (Object)new ReifiedType.Annotated[]{ReifiedType.Annotated.unannotated(Void.TYPE)}).verify();
    }

    @Test
    public void toStringTest() {
        MethodYield methodYield = new MethodYield();
        try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(MethodYieldTest.class);){
            methodYieldFor.returnValue(this.sample, "myvalue");
        }
        Assertions.assertTrue((boolean)methodYield.toString().contains("myvalue"));
    }
}

