/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.InvokeDefaultFunction;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.MAINTAINED)
public final class MethodYield {
    private final @NonNull Map<Class<?>, Map<MethodId, Object>> backing;
    private transient int sizeEstimate;
    private transient Class<?> currentImplementable;
    private static final InvokeDefaultFunction INVOKE_DEFAULT_FUNCTION = new InvokeDefaultFunction();

    public MethodYield() {
        this(new HashMap());
    }

    private MethodYield(Map<Class<?>, Map<MethodId, Object>> backing) {
        this.backing = backing;
    }

    public ForImplementable forImplementable(@NonNull Class<?> implementable) {
        Objects.requireNonNull(implementable, "implementable");
        if (this.backing.containsKey(implementable)) {
            throw new IllegalStateException("Called already for " + implementable);
        }
        if (this.currentImplementable != null) {
            throw new IllegalStateException("Existing handler must be closed");
        }
        this.currentImplementable = implementable;
        return new ForImplementable();
    }

    public void clear() {
        this.backing.clear();
        this.sizeEstimate = 0;
    }

    public Map<@NonNull MethodId, @NonNull Object> valuesFor(@NonNull Class<?> implementable) {
        return this.backing.getOrDefault(implementable, ImmutableCollections.emptyMap());
    }

    public @NonNull Iterable<@NonNull Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public @NonNull Iterator<Entry> iterator() {
                return new Iter(MethodYield.this.backing.entrySet().iterator());
            }

            @Override
            public void forEach(Consumer<? super Entry> action) {
                MethodYield.this.backing.forEach((? super K implementable, ? super V methodMap) -> methodMap.entrySet().forEach((? super T methodAndValue) -> action.accept(new Entry((Class<?>)implementable, (Map.Entry<MethodId, Object>)methodAndValue))));
            }
        };
    }

    public int sizeEstimate() {
        return this.sizeEstimate;
    }

    public @NonNull MethodYield copy() {
        HashMap copyBacking = new HashMap(this.backing.size());
        this.backing.forEach((clazz, values) -> copyBacking.put((Class<?>)clazz, (Map<MethodId, Object>)new HashMap(values)));
        MethodYield copy = new MethodYield(copyBacking);
        copy.sizeEstimate = this.sizeEstimate;
        return copy;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodYield)) {
            return false;
        }
        MethodYield that = (MethodYield)o;
        return this.backing.equals(that.backing);
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.backing + '}';
    }

    public final class ForImplementable
    implements AutoCloseable {
        private final Map<MethodId, Object> methodMap = new HashMap<MethodId, Object>();

        public void returnValue(@NonNull MethodId method, @NonNull Object value) {
            Objects.requireNonNull(method, "method");
            Objects.requireNonNull(value, "value");
            this.methodMap.put(method, value);
        }

        public void callDefaultImpl(@NonNull MethodId method) {
            Objects.requireNonNull(method, "method");
            this.methodMap.put(method, INVOKE_DEFAULT_FUNCTION);
        }

        @Override
        public void close() {
            if (MethodYield.this.currentImplementable == null) {
                return;
            }
            if (!this.methodMap.isEmpty()) {
                MethodYield.this.backing.put(MethodYield.this.currentImplementable, this.methodMap);
                MethodYield.this.sizeEstimate += this.methodMap.size();
            }
            MethodYield.this.currentImplementable = null;
        }
    }

    private static final class Iter
    implements Iterator<Entry> {
        private final Iterator<Map.Entry<Class<?>, Map<MethodId, Object>>> backing;
        private Class<?> currentType;
        private Iterator<Map.Entry<MethodId, Object>> currentMap;

        private Iter(Iterator<Map.Entry<Class<?>, Map<MethodId, Object>>> backing) {
            this.backing = backing;
        }

        @Override
        public boolean hasNext() {
            return this.currentMap != null && this.currentMap.hasNext() || this.backing.hasNext();
        }

        @Override
        public Entry next() {
            if (this.currentMap == null || !this.currentMap.hasNext()) {
                Map.Entry<Class<?>, Map<MethodId, Object>> nextMap = this.backing.next();
                this.currentType = nextMap.getKey();
                this.currentMap = nextMap.getValue().entrySet().iterator();
            }
            return new Entry(this.currentType, this.currentMap.next());
        }
    }

    public static final class Entry {
        private final Class<?> implementable;
        private final Map.Entry<MethodId, Object> methodAndValue;

        Entry(Class<?> implementable, Map.Entry<MethodId, Object> methodAndValue) {
            this.implementable = implementable;
            this.methodAndValue = methodAndValue;
        }

        public @NonNull Class<?> implementable() {
            return this.implementable;
        }

        public @NonNull MethodId method() {
            return this.methodAndValue.getKey();
        }

        public @NonNull Object returnValue() {
            return this.methodAndValue.getValue();
        }
    }
}

