/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Utilities;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MethodIdTest {
    private final Method sampleOne = Sample.class.getDeclaredMethod("sampleOne", String.class);
    private final Method sampleTwo = Sample.class.getDeclaredMethod("sampleTwo", new Class[0]);
    private final ReifiedType.Annotated voidType = ReifiedType.Annotated.unannotated(Void.TYPE);
    private final ReifiedType.Annotated booleanType = ReifiedType.Annotated.unannotated(Boolean.TYPE);
    private final ReifiedType.Annotated stringType = ReifiedType.Annotated.unannotated(String.class);

    @Test
    public void construct() {
        MethodId sampleOneId = new MethodId("sampleOne", this.voidType, new ReifiedType[]{this.stringType}, false);
        Assertions.assertNull((Object)sampleOneId.getOpaqueCache());
        Assertions.assertEquals((Object)"sampleOne", (Object)sampleOneId.name());
        Assertions.assertEquals((Object)this.voidType, (Object)sampleOneId.returnType());
        Assertions.assertArrayEquals((Object[])new ReifiedType[]{this.stringType}, (Object[])sampleOneId.parameters());
        Assertions.assertEquals((int)1, (int)sampleOneId.parameterCount());
        Assertions.assertEquals((Object)this.stringType, (Object)sampleOneId.parameterAt(0));
        Assertions.assertFalse((boolean)sampleOneId.isDefault());
        MethodId sampleTwoId = (MethodId)Assertions.assertDoesNotThrow(() -> new MethodId("sampleTwo", this.booleanType, new ReifiedType[0], true));
        Assertions.assertNull((Object)sampleTwoId.getOpaqueCache());
        Assertions.assertEquals((Object)"sampleTwo", (Object)sampleTwoId.name());
        Assertions.assertEquals((Object)this.booleanType, (Object)sampleTwoId.returnType());
        Assertions.assertArrayEquals((Object[])new ReifiedType[0], (Object[])sampleTwoId.parameters());
        Assertions.assertTrue((boolean)sampleTwoId.isDefault());
    }

    @Test
    public void constructNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MethodId(null, this.stringType, new ReifiedType[]{this.stringType}, false));
        Assertions.assertThrows(NullPointerException.class, () -> new MethodId("sampleOne", null, new ReifiedType[]{this.stringType}, false));
        Assertions.assertThrows(NullPointerException.class, () -> new MethodId("sampleOne", this.stringType, null, false));
        Assertions.assertThrows(NullPointerException.class, () -> new MethodId("sampleOne", this.stringType, new ReifiedType[]{null}, false));
    }

    @Test
    public void withOpaqueCache() {
        MethodId original = new MethodId("sampleOne", this.voidType, new ReifiedType[]{this.stringType}, false);
        MethodId withCache = original.withOpaqueCache(new Cache(this.sampleOne));
        Assertions.assertNotNull((Object)withCache.getOpaqueCache());
        Assertions.assertSame((Object)this.sampleOne, (Object)((Cache)withCache.getOpaqueCache()).method);
        Assertions.assertEquals((Object)"sampleOne", (Object)withCache.name(), (String)"same details");
        Utilities.assertEqualsBothWays(original, withCache);
        MethodId withCacheCleared = withCache.withOpaqueCache(null);
        Assertions.assertNull((Object)withCacheCleared.getOpaqueCache());
        Utilities.assertEqualsBothWays(withCache, withCacheCleared);
        Utilities.assertEqualsBothWays(original, withCacheCleared);
    }

    @Test
    public void toStringTest() {
        MethodId sampleOne = new MethodId("sampleOne", this.voidType, new ReifiedType[]{this.stringType}, false);
        String toString = sampleOne.toString();
        Assertions.assertTrue((boolean)toString.contains("sampleOne"));
        Assertions.assertTrue((boolean)toString.contains(String.class.getSimpleName()));
        MethodId sampleTwo = new MethodId("sampleTwo", this.booleanType, new ReifiedType[0], true);
        toString = sampleTwo.toString();
        Assertions.assertTrue((boolean)toString.contains("default"));
        Assertions.assertTrue((boolean)toString.contains("sampleTwo"));
    }

    static interface Sample {
        public void sampleOne(String var1);

        default public boolean sampleTwo() {
            return true;
        }
    }

    record Cache(Method method) implements MethodId.OpaqueCache
    {
    }
}

