/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public final class MethodId {
    private final transient OpaqueCache opaqueCache;
    private final String name;
    private final ReifiedType.Annotated returnType;
    private final ReifiedType[] parameters;
    private final boolean isDefault;

    public MethodId(@NonNull String name, @NonNull ReifiedType.Annotated returnType, @NonNull ReifiedType @NonNull [] parameters, boolean isDefault) {
        this.opaqueCache = null;
        this.name = Objects.requireNonNull(name, "name");
        this.returnType = Objects.requireNonNull(returnType, "returnType");
        for (ReifiedType parameter : this.parameters = (ReifiedType[])parameters.clone()) {
            Objects.requireNonNull(parameter, "parameters");
        }
        this.isDefault = isDefault;
    }

    private MethodId(OpaqueCache opaqueCache, String name, ReifiedType.Annotated returnType, ReifiedType[] parameters, boolean isDefault) {
        this.opaqueCache = opaqueCache;
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
        this.isDefault = isDefault;
    }

    public @NonNull MethodId withOpaqueCache(@Nullable OpaqueCache opaqueCache) {
        if (this.opaqueCache == opaqueCache) {
            return this;
        }
        return new MethodId(opaqueCache, this.name, this.returnType, this.parameters, this.isDefault);
    }

    @Pure
    public @Nullable OpaqueCache getOpaqueCache() {
        return this.opaqueCache;
    }

    public @NonNull String name() {
        return this.name;
    }

    @NonNull Method getMethod(@NonNull Class<?> declaringClass) {
        Class[] rawParams = new Class[this.parameters.length];
        for (int n = 0; n < this.parameters.length; ++n) {
            rawParams[n] = this.parameters[n].rawType();
        }
        try {
            return declaringClass.getMethod(this.name, rawParams);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Specified method does not exist on target class", ex);
        }
    }

    @NonNull MethodHandle getMethodHandle( @NonNull MethodHandles.Lookup lookup, @NonNull Class<?> declaringClass) throws IllegalAccessException {
        Class[] rawParams = new Class[this.parameters.length];
        for (int n = 0; n < this.parameters.length; ++n) {
            rawParams[n] = this.parameters[n].rawType();
        }
        try {
            return lookup.findVirtual(declaringClass, this.name, MethodType.methodType(this.returnType.rawType(), rawParams));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Specified method does not exist on target class", ex);
        }
    }

    public @NonNull ReifiedType.Annotated returnType() {
        return this.returnType;
    }

    public @NonNull ReifiedType parameterAt(int index) {
        return this.parameters[index];
    }

    public int parameterCount() {
        return this.parameters.length;
    }

    public @NonNull ReifiedType @NonNull [] parameters() {
        return (ReifiedType[])this.parameters.clone();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodId)) {
            return false;
        }
        MethodId methodId = (MethodId)o;
        return this.isDefault == methodId.isDefault && this.name.equals(methodId.name) && this.returnType.equals(methodId.returnType) && Arrays.equals(this.parameters, methodId.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + Boolean.hashCode(this.isDefault);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isDefault) {
            builder.append("default ");
        }
        builder.append(this.name);
        builder.append('(');
        for (int n = 0; n < this.parameters.length; ++n) {
            if (n != 0) {
                builder.append(',');
            }
            this.parameters[n].toString(builder);
        }
        builder.append(')');
        return builder.toString();
    }

    public static interface OpaqueCache {
    }
}

