/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ArrayType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class GenericContext {
    private final ReifiedType.Annotated parent;
    private final TypeVariable<?>[] typeVars;

    GenericContext( @NonNull ReifiedType.Annotated parent) {
        this.parent = parent;
        TypeVariable<Class<?>>[] typeVars = parent.rawType().getTypeParameters();
        if (typeVars.length != parent.argumentCount()) {
            throw new IllegalStateException("Malformed input type. Wrong number of arguments on " + parent);
        }
        this.typeVars = typeVars;
    }

    private ReifiedType.Annotated getTypeArgument(String varName) {
        for (int n = 0; n < this.typeVars.length; ++n) {
            if (!this.typeVars[n].getName().equals(varName)) continue;
            return this.parent.argumentAt(n);
        }
        return this.unknownVariable(varName);
    }

    abstract ReifiedType.Annotated unknownVariable(String var1);

    ReifiedType.Annotated reify(AnnotatedType type) {
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] sourceArgs = parameterizedType.getAnnotatedActualTypeArguments();
            ReifiedType.Annotated[] reifiedArgs = new ReifiedType.Annotated[sourceArgs.length];
            for (int n = 0; n < sourceArgs.length; ++n) {
                reifiedArgs[n] = this.reify(sourceArgs[n]);
            }
            Class mainType = (Class)((ParameterizedType)parameterizedType.getType()).getRawType();
            return new ReifiedType.Annotated(mainType, reifiedArgs, type);
        }
        if (type instanceof AnnotatedTypeVariable) {
            return this.getTypeArgument(((TypeVariable)type.getType()).getName());
        }
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wildcardType = (AnnotatedWildcardType)type;
            return this.reify(wildcardType.getAnnotatedUpperBounds()[0]);
        }
        if (type instanceof AnnotatedArrayType) {
            AnnotatedArrayType arrayType = (AnnotatedArrayType)type;
            AnnotatedType annotatedComponent = arrayType.getAnnotatedGenericComponentType();
            ReifiedType.Annotated reifiedComponent = this.reify(annotatedComponent);
            return new ReifiedType.Annotated(ArrayType.arrayType(reifiedComponent.rawType()), reifiedComponent.arguments(), annotatedComponent);
        }
        Type rawType = type.getType();
        if (rawType instanceof Class) {
            return new ReifiedType.Annotated((Class)rawType, ReifiedType.Annotated.EMPTY_ARRAY, type);
        }
        throw new IllegalStateException("Unable to reify type " + type + " within a method of " + this.parent);
    }
}

