/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.GenericContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodCache;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ProxyHandler;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DefaultMethodMirror
implements MethodMirror {
    private final MethodHandles.Lookup lookup;

    DefaultMethodMirror(MethodHandles.Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public @NonNull MethodMirror.TypeWalker typeWalker(@NonNull ReifiedType.Annotated reifiedType) {
        return new Walker(reifiedType);
    }

    @Override
    public @NonNull MethodMirror.Invoker makeInvoker(@NonNull Object receiver, @NonNull Class<?> enclosingType) {
        InvocationHandler invocationHandler;
        ProxyHandler proxyHandler = null;
        if (Proxy.isProxyClass(receiver.getClass()) && (invocationHandler = Proxy.getInvocationHandler(receiver)) instanceof ProxyHandler) {
            proxyHandler = (ProxyHandler)invocationHandler;
        }
        return new Invoke(receiver, proxyHandler);
    }

    private static final class Walker
    implements MethodMirror.TypeWalker {
        private final ReifiedType.Annotated enclosingType;
        private final GenericContext classGenerics;

        private Walker(ReifiedType.Annotated enclosingType) {
            this.enclosingType = enclosingType;
            this.classGenerics = new GenericContext(enclosingType){

                @Override
                ReifiedType.Annotated unknownVariable(String varName) {
                    return ReifiedType.Annotated.unannotated(Object.class);
                }
            };
        }

        @Override
        public @NonNull ReifiedType.Annotated getEnclosingType() {
            return this.enclosingType;
        }

        @Override
        public @NonNull Stream<@NonNull MethodId> getViableMethods() {
            Class<?> declaringClass = this.enclosingType.rawType();
            Method[] classMethods = declaringClass.getDeclaredMethods();
            return Arrays.stream(classMethods).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isSynthetic() && !method.isBridge()).map(method -> {
                ReifiedType.Annotated reifiedReturn = this.classGenerics.reify(method.getAnnotatedReturnType());
                AnnotatedType[] methodParameters = method.getAnnotatedParameterTypes();
                ReifiedType[] reifiedParameters = methodParameters.length == 0 ? ReifiedType.Annotated.EMPTY_ARRAY : new ReifiedType[methodParameters.length];
                for (int n = 0; n < reifiedParameters.length; ++n) {
                    reifiedParameters[n] = this.classGenerics.reify(methodParameters[n]);
                }
                MethodId methodId = new MethodId(method.getName(), reifiedReturn, reifiedParameters, method.isDefault());
                return methodId.withOpaqueCache(new MethodCache((Method)method));
            });
        }

        @Override
        public @NonNull AnnotatedElement getAnnotations(@NonNull MethodId methodId) {
            MethodId.OpaqueCache methodCache = methodId.getOpaqueCache();
            assert (methodCache instanceof MethodCache);
            return ((MethodCache)methodCache).method;
        }

        @Override
        public @NonNull MethodMirror.TypeWalker @NonNull [] getSuperTypes() {
            AnnotatedType[] annotatedInterfaces = this.enclosingType.rawType().getAnnotatedInterfaces();
            MethodMirror.TypeWalker[] superTypes = new MethodMirror.TypeWalker[annotatedInterfaces.length];
            for (int n = 0; n < annotatedInterfaces.length; ++n) {
                superTypes[n] = new Walker(this.classGenerics.reify(annotatedInterfaces[n]));
            }
            return superTypes;
        }
    }

    private final class Invoke
    implements MethodMirror.Invoker {
        private final Object receiver;
        private final ProxyHandler<?> proxyHandler;

        private Invoke(Object receiver, ProxyHandler<?> proxyHandler) {
            this.receiver = receiver;
            this.proxyHandler = proxyHandler;
        }

        @Override
        public @Nullable Object invokeMethod(@NonNull MethodId methodId, Object ... arguments) throws InvocationTargetException {
            MethodHandle methodHandle;
            Object fastPath;
            if (this.proxyHandler != null && methodId.parameterCount() == 0 && (fastPath = this.proxyHandler.fastPathNoParams(methodId.name())) != null) {
                return fastPath;
            }
            MethodId.OpaqueCache methodCache = methodId.getOpaqueCache();
            assert (methodCache instanceof MethodCache);
            Method method = ((MethodCache)methodCache).method;
            if (this.proxyHandler != null) {
                try {
                    return this.proxyHandler.implInvoke(method, arguments);
                }
                catch (Throwable ex) {
                    throw new InvocationTargetException(ex);
                }
            }
            try {
                methodHandle = DefaultMethodMirror.this.lookup.unreflect(method);
            }
            catch (IllegalAccessException ex) {
                throw new DeveloperMistakeException("Configuration method inaccessible", ex);
            }
            try {
                return methodHandle.bindTo(this.receiver).invokeWithArguments(arguments);
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }
}

