/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Transition;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Migration<C_OLD, C_NEW> {
    private final MigrateSource<C_OLD> migrateSource;
    private final Transition<C_OLD, C_NEW> transition;

    public Migration(@NonNull MigrateSource<C_OLD> migrateSource, @NonNull Transition<C_OLD, C_NEW> transition) {
        this.migrateSource = Objects.requireNonNull(migrateSource, "migrateSource");
        this.transition = Objects.requireNonNull(transition, "transition");
    }

    public @NonNull LoadResult<@NonNull C_NEW> tryMigrate(@NonNull MigrateContext migrateContext) {
        return this.migrateSource.load(migrateContext).map(loaded -> {
            C_NEW transitioned = this.transition.migrateFrom(loaded, migrateContext);
            return Objects.requireNonNull(transitioned, "transition returned null");
        });
    }

    public void onCompletion() {
        this.migrateSource.onCompletion();
    }
}

