/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationBuilder;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateFromConfiguration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class MigrateFromConfigurationTest {
    private Configuration<Config> configuration;
    private final MigrateContext migrateContext;
    private final Backend mainBackend;

    public MigrateFromConfigurationTest(@Mock MigrateContext migrateContext, @Mock Backend mainBackend) {
        this.migrateContext = migrateContext;
        this.mainBackend = mainBackend;
    }

    @BeforeEach
    public void setup(@Mock ErrorContext.Source errorSource, @Mock ErrorContext dummyError) {
        this.configuration = new ConfigurationBuilder<Config>(new TypeToken<Config>(this){}).addTypeLiaisons(new StringLiaison()).build();
        Mockito.lenient().when((Object)this.mainBackend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        Mockito.lenient().when((Object)this.migrateContext.errorSource()).thenReturn((Object)errorSource);
        Mockito.lenient().when(errorSource.throwError((CharSequence)ArgumentMatchers.any())).thenReturn(LoadResult.failure(dummyError));
    }

    @Test
    public void nullTreeYieldsError() {
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.of(null));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).load(this.migrateContext);
        Assertions.assertFalse((boolean)loadResult.isSuccess());
    }

    @Test
    public void failedTreeYieldsError(@Mock ErrorContext errorContext) {
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.failure(errorContext));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).load(this.migrateContext);
        Assertions.assertFalse((boolean)loadResult.isSuccess());
        Assertions.assertEquals((Object)errorContext, (Object)loadResult.getErrorContexts().getFirst());
    }

    @Test
    public void successYieldsValue() {
        DataTree.Mut backendTree = new DataTree.Mut();
        backendTree.put("source", new DataEntry("yay"));
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.of(Backend.Document.simple(backendTree)));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).load(this.migrateContext);
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        Assertions.assertEquals((Object)"yay", (Object)loadResult.getOrThrow().source());
    }

    @Test
    public void listenToUpdates() {
        DataTree.Mut backendTree = new DataTree.Mut();
        backendTree.put("other", new DataEntry("no!"));
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.of(Backend.Document.simple(backendTree)));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).load(this.migrateContext);
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        Assertions.assertEquals((Object)"fallback", (Object)loadResult.getOrThrow().source());
        ((MigrateContext)Mockito.verify((Object)this.migrateContext)).notifyUpdate(new KeyPath.Mut("source"), UpdateReason.MIGRATED);
    }

    @Test
    public void filterNotUsable() {
        DataTree.Mut backendTree = new DataTree.Mut();
        backendTree.put("other", new DataEntry("no!"));
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.of(Backend.Document.simple(backendTree)));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).addFilter(config -> !config.source().equals("fallback")).load(this.migrateContext);
        Assertions.assertFalse((boolean)loadResult.isSuccess());
        ((MigrateContext)Mockito.verify((Object)this.migrateContext, (VerificationMode)Mockito.never())).notifyUpdate((KeyPath)ArgumentMatchers.any(), (UpdateReason)((Object)ArgumentMatchers.any()));
    }

    @Test
    public void filterStillUsable() {
        DataTree.Mut backendTree = new DataTree.Mut();
        backendTree.put("source", new DataEntry("yay"));
        Mockito.when(this.mainBackend.read((ErrorContext.Source)ArgumentMatchers.any())).thenReturn(LoadResult.of(Backend.Document.simple(backendTree)));
        Mockito.when((Object)this.migrateContext.mainBackend()).thenReturn((Object)this.mainBackend);
        LoadResult<Config> loadResult = new MigrateFromConfiguration<Config>(this.configuration).addFilter(config -> !config.source().equals("fallback")).load(this.migrateContext);
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        Assertions.assertEquals((Object)"yay", (Object)loadResult.getOrThrow().source());
    }

    public static interface Config {
        default public String source() {
            return "fallback";
        }
    }
}

