/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MigrateFromConfiguration<C>
implements MigrateSource<C> {
    private final Configuration<C> config;
    private final List<MigrateSource.Filter<C>> filters;

    private MigrateFromConfiguration(@NonNull Configuration<C> config, @NonNull List<@NonNull MigrateSource.Filter<C>> filters) {
        this.config = Objects.requireNonNull(config);
        this.filters = filters;
    }

    public MigrateFromConfiguration(@NonNull Configuration<C> config) {
        this(config, ImmutableCollections.emptyList());
    }

    @Override
    public @NonNull LoadResult<@NonNull C> load(@NonNull MigrateContext migrateContext) {
        final ArrayList updatedPaths = new ArrayList();
        final Backend mainBackend = migrateContext.mainBackend();
        return mainBackend.read(migrateContext.errorSource()).flatMap(document -> {
            if (document == null) {
                return migrateContext.errorSource().throwError("Main backend produced empty document");
            }
            return this.config.readFrom(document.data(), new ConfigurationDefinition.ReadOptions(){

                @Override
                public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                    updatedPaths.add(entryPath);
                }

                @Override
                public @NonNull KeyMapper keyMapper() {
                    return mainBackend.recommendKeyMapper();
                }

                @Override
                public @NonNull KeyPath keyPath() {
                    return KeyPath.empty();
                }
            });
        }).flatMap(loaded -> {
            for (MigrateSource.Filter<C> filter : this.filters) {
                if (filter.isUsable(loaded)) continue;
                return migrateContext.errorSource().throwError("Filtered by " + filter);
            }
            for (KeyPath updatedPath : updatedPaths) {
                migrateContext.notifyUpdate(updatedPath, UpdateReason.MIGRATED);
            }
            return LoadResult.of(loaded);
        });
    }

    @Override
    public void onCompletion() {
    }

    @Override
    public @NonNull MigrateSource<C> addFilter(@NonNull MigrateSource.Filter<C> filter) {
        ArrayList<MigrateSource.Filter<C>> newFilters = new ArrayList<MigrateSource.Filter<C>>(this.filters);
        newFilters.add(filter);
        return new MigrateFromConfiguration<C>(this.config, newFilters);
    }
}

