/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LangAr;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LangEn;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LibraryLangTest {
    @Test
    public void loadEnglish() {
        assert (LibraryLang.loadLang(Locale.ENGLISH).getChosen() instanceof LangEn);
        assert (LibraryLang.loadLang(Locale.US).getChosen() instanceof LangEn);
        assert (LibraryLang.loadLang(Locale.UK).getChosen() instanceof LangEn);
        assert (LibraryLang.loadLang(Locale.CANADA).getChosen() instanceof LangEn);
    }

    @Test
    public void loadArabic() {
        assert (LibraryLang.loadLang(Locale.of("ar")).getChosen() instanceof LangAr);
        assert (LibraryLang.loadLang(Locale.of("ar", "JO")).getChosen() instanceof LangAr);
        assert (LibraryLang.loadLang(Locale.of("ar", "EG")).getChosen() instanceof LangAr);
        assert (LibraryLang.loadLang(Locale.of("ar", "DZ")).getChosen() instanceof LangAr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadAny() {
        PrintStream originalSysOut = System.out;
        System.setOut(new PrintStream(OutputStream.nullOutputStream()));
        try {
            for (Locale locale : Locale.getAvailableLocales()) {
                LibraryLang loaded = (LibraryLang)Assertions.assertDoesNotThrow(() -> LibraryLang.loadLang(locale), () -> "threw for " + String.valueOf(locale));
                Assertions.assertNotNull((Object)loaded, () -> "loaded null for " + String.valueOf(locale));
            }
        }
        finally {
            System.setOut(originalSysOut);
        }
    }

    @Test
    public void preserveDialect() {
        Assertions.assertEquals((Object)Locale.CANADA, (Object)LibraryLang.loadLang(Locale.CANADA).getLocale());
        Locale arJo = Locale.of("ar", "JO");
        Assertions.assertEquals((Object)arJo, (Object)LibraryLang.loadLang(arJo).getLocale());
    }
}

