/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LangEn;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LanguageCandidate;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LanguageMessages;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.ReadMe;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LibraryLang
implements LanguageMessages {
    private final Locale usingLocale;
    private final LanguageCandidate chosen;

    private LibraryLang(Locale usingLocale, LanguageCandidate chosen) {
        this.usingLocale = usingLocale;
        this.chosen = chosen;
    }

    public @NonNull Locale getLocale() {
        return this.usingLocale;
    }

    public @NonNull Locale getActualLocale() {
        return this.chosen.getActualLocale();
    }

    public LanguageCandidate getChosen() {
        return this.chosen;
    }

    private static @Nullable LanguageCandidate bestCandidate(@NonNull Locale usingLocale) {
        LanguageCandidate bestGuess = null;
        for (LanguageCandidate candidate : ReadMe.availableLanguages()) {
            if (!candidate.supportsLocale(usingLocale)) continue;
            if (candidate.getActualLocale().equals(usingLocale)) {
                return candidate;
            }
            bestGuess = candidate;
        }
        return bestGuess;
    }

    public static @NonNull LibraryLang loadLang(@NonNull Locale usingLocale) {
        LanguageCandidate chosen = LibraryLang.bestCandidate(usingLocale);
        if (chosen == null) {
            System.out.println("Message from DazzleConf 2 (preview): The requested language " + usingLocale.getLanguage() + " does not have a translation yet. If you would like to contribute one, please make a PR.");
            chosen = new LangEn();
        }
        return new LibraryLang(usingLocale, chosen);
    }

    public @NonNull Printable wrongTypeForValue(final @NonNull Object value, final @NonNull Class<?> expectedType) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(expectedType, "expectedType");
        return new Printable.Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                output.append(LibraryLang.this.badValue());
                output.append(' ');
                LibraryLang.this.wrongTypeForValue(value, LibraryLang.this.displayCanonicalType(expectedType), LibraryLang.this.displayCanonicalType(value.getClass())).printTo(output);
            }
        };
    }

    public @NonNull Printable outOfRange(final @NonNull Object value, final @NonNull Number min, final @NonNull Number max) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(min, "min");
        Objects.requireNonNull(max, "max");
        return new Printable.Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                output.append(LibraryLang.this.badValue());
                output.append(' ');
                LibraryLang.this.mustBeBetween(LibraryLang.this.displayCanonicalType(value.getClass()), min, max).printTo(output);
            }
        };
    }

    public @NonNull String formatNumber(@NonNull Number value) {
        return NumberFormat.getInstance(this.usingLocale).format(value);
    }

    public @NonNull Printable notANumber(final @NonNull Number value) {
        Objects.requireNonNull(value, "value");
        return new Printable.Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                output.append(LibraryLang.this.badValue());
                output.append(' ');
                LibraryLang.this.wrongTypeForValue(value, LibraryLang.this.displayCanonicalType(value.getClass()), LibraryLang.this.formatNumber(value)).printTo(output);
            }
        };
    }

    private String displayCanonicalType(Class<?> type) {
        assert (!type.isPrimitive()) : "Use wrapper type";
        if (type.equals(String.class)) {
            return this.text();
        }
        if (type.equals(Boolean.class)) {
            return this.trueFalse();
        }
        if (type.equals(Byte.class)) {
            return this.smallInteger();
        }
        if (type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class)) {
            return this.integer();
        }
        if (type.equals(Character.class)) {
            return this.character();
        }
        if (type.equals(Float.class) || type.equals(Double.class)) {
            return this.decimal();
        }
        if (DataList.class.isAssignableFrom(type)) {
            return this.list();
        }
        if (DataTree.class.isAssignableFrom(type)) {
            return this.configurationSection();
        }
        throw new IllegalArgumentException("Not a canonical type " + type);
    }

    public @NonNull String more(int howMany) {
        return this.chosen.more(this.formatNumber(howMany));
    }

    @Override
    public @NonNull String location() {
        return this.chosen.location();
    }

    @Override
    public @NonNull String line() {
        return this.chosen.line();
    }

    @Override
    public @NonNull String backendMessage() {
        return this.chosen.backendMessage();
    }

    @Override
    public @NonNull String syntaxLinter() {
        return this.chosen.syntaxLinter();
    }

    @Override
    public @NonNull String failed() {
        return this.chosen.failed();
    }

    @Override
    public @NonNull String missingValue() {
        return this.chosen.missingValue();
    }

    @Override
    public @NonNull Printable wrongTypeForValue(Object value, String expectedType, String actualType) {
        return this.chosen.wrongTypeForValue(value, expectedType, actualType);
    }

    @Override
    public @NonNull Printable mustBeBetween(String value, Number min, Number max) {
        return this.chosen.mustBeBetween(value, min, max);
    }

    @Override
    public @NonNull Printable notAccepted(@NonNull String value, @NonNull String[] permitted) {
        return this.chosen.notAccepted(value, permitted);
    }

    @Override
    public @NonNull String forExample() {
        return this.chosen.forExample();
    }

    @Override
    public @NonNull String badValue() {
        return this.chosen.badValue();
    }

    @Override
    public @NonNull String more(String what) {
        return this.chosen.more(what);
    }

    @Override
    public @NonNull String errorIntro() {
        return this.chosen.errorIntro();
    }

    @Override
    public @NonNull String errorContext() {
        return this.chosen.errorContext();
    }

    @Override
    public @NonNull String trueFalse() {
        return this.chosen.trueFalse();
    }

    @Override
    public @NonNull String text() {
        return this.chosen.text();
    }

    @Override
    public @NonNull String smallInteger() {
        return this.chosen.smallInteger();
    }

    @Override
    public @NonNull String integer() {
        return this.chosen.integer();
    }

    @Override
    public @NonNull String character() {
        return this.chosen.character();
    }

    @Override
    public @NonNull String decimal() {
        return this.chosen.decimal();
    }

    @Override
    public @NonNull String list() {
        return this.chosen.list();
    }

    @Override
    public @NonNull String configurationSection() {
        return this.chosen.configurationSection();
    }

    @Override
    public @NonNull String syntaxInvalidPleaseTryAt(@NonNull URL url) {
        return this.chosen.syntaxInvalidPleaseTryAt(url);
    }

    @Override
    public @NonNull String syntax() {
        return this.chosen.syntax();
    }

    @Override
    public @NonNull String otherReason() {
        return this.chosen.otherReason();
    }

    @Override
    public @NonNull String yamlNotAMap() {
        return this.chosen.yamlNotAMap();
    }

    @Override
    public @NonNull String tomlDateType() {
        return this.chosen.tomlDateType();
    }

    public static interface Key {
        public String getMessage(LibraryLang var1);
    }

    public static interface Accessor {
        public @NonNull LibraryLang getLibraryLang();

        public static <S> LibraryLang access(S source, Function<S, Locale> localeFallback) {
            if (source instanceof Accessor) {
                return ((Accessor)source).getLibraryLang();
            }
            return LibraryLang.loadLang(localeFallback.apply(source));
        }
    }
}

