/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ImmutableCollections {
    private ImmutableCollections() {
    }

    public static <E> List<E> emptyList() {
        return Collections.emptyList();
    }

    public static <E> List<E> listOf(E element) {
        Objects.requireNonNull(element, "element");
        return Collections.singletonList(element);
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        for (Object element : elements = (Object[])elements.clone()) {
            Objects.requireNonNull(element, "element");
        }
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <E> List<E> listOf(Collection<? extends E> coll) {
        Object[] arr = coll.toArray();
        if (arr.length == 0) {
            return Collections.emptyList();
        }
        return ImmutableCollections.listOf(arr);
    }

    public static <E> Set<E> emptySet() {
        return Collections.emptySet();
    }

    public static <E> Set<E> setOf(E element) {
        Objects.requireNonNull(element, "element");
        return Collections.singleton(element);
    }

    public static <E> Set<E> setOf(Collection<? extends E> coll) {
        if (coll.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<E> copy = new HashSet<E>(coll);
        for (Object element : copy) {
            Objects.requireNonNull(element, "element");
        }
        return Collections.unmodifiableSet(copy);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapOf(Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> copy = new HashMap<K, V>(map);
        for (Map.Entry entry : copy.entrySet()) {
            Objects.requireNonNull(entry.getKey(), "key");
            Objects.requireNonNull(entry.getValue(), "value");
        }
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V> Map.Entry<K, V> mapEntryOf(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }
}

