/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.AccessChecking;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccessCheckingTest {
    @Test
    public void publicAndExportedIsAccessible() {
        Assertions.assertTrue((boolean)AccessChecking.isAccessible(Object.class));
    }

    @Test
    public void nonPublicIsInaccessible() {
        Assertions.assertFalse((boolean)AccessChecking.isAccessible(List.of().getClass()));
    }

    @Test
    public void publicButNotExportedIsInaccessible() {
        Class<?> algorithmId;
        try {
            algorithmId = Class.forName("sun.security.x509.AlgorithmId");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Please update this test to the latest JDK", ex);
        }
        Assertions.assertTrue((boolean)Modifier.isPublic(algorithmId.getModifiers()));
        Assertions.assertFalse((boolean)algorithmId.getModule().isExported(algorithmId.getPackageName()), (String)("Expected " + String.valueOf(algorithmId.getModule()) + " to not be exported"));
        Assertions.assertFalse((boolean)AccessChecking.isAccessible(algorithmId));
    }
}

