/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class TimeLiaison
implements TypeLiaison {
    private final DateTimeFormatter formatter;

    public TimeLiaison(@NonNull DateTimeFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter);
    }

    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        return TypeLiaison.Agent.matchOnToken(typeToken, Instant.class, () -> new InstantAgent());
    }

    private final class InstantAgent
    implements TypeLiaison.Agent<Instant> {
        private InstantAgent() {
        }

        @Override
        @SideEffectFree
        public @Nullable DefaultValues<Instant> loadDefaultValues(@NonNull TypeLiaison.DefaultInit defaultInit) {
            return null;
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<Instant> makeSerializer() {
            return new SerializeDeserialize<Instant>(){

                @Override
                public @NonNull LoadResult<@NonNull Instant> deserialize(@NonNull DeserializeInput deser) {
                    return deser.requireString().flatMap(string -> {
                        Instant parsed;
                        try {
                            parsed = TimeLiaison.this.formatter.parse((CharSequence)string, Instant::from);
                        }
                        catch (DateTimeParseException failure) {
                            return deser.throwError(failure.getMessage());
                        }
                        return LoadResult.of(parsed);
                    });
                }

                @Override
                public void serialize(@NonNull Instant value, @NonNull SerializeOutput ser) {
                    ser.outString(TimeLiaison.this.formatter.format(value));
                }
            };
        }
    }
}

