/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SubSection;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class SubSectionLiaison
implements TypeLiaison {
    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        if (typeToken.getReifiedType().getAnnotation(SubSection.class) != null) {
            return new SectionAgent<V>(handshake.getConfiguration(typeToken));
        }
        return null;
    }

    private static class SectionAgent<V>
    implements TypeLiaison.Agent<V> {
        private final ConfigurationDefinition<V> configuration;

        SectionAgent(ConfigurationDefinition<V> configuration) {
            this.configuration = configuration;
        }

        @Override
        @SideEffectFree
        public @Nullable DefaultValues<V> loadDefaultValues(@NonNull TypeLiaison.DefaultInit<V> defaultInit) {
            DefaultValues<V> methodDefault = defaultInit.methodDefault();
            if (methodDefault != null) {
                return methodDefault;
            }
            return new DefaultValues<V>(){

                @Override
                public @NonNull V defaultValue() {
                    return configuration.loadDefaults();
                }

                @Override
                public @NonNull V ifMissing() {
                    return configuration.loadDefaults();
                }
            };
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<V> makeSerializer() {
            return new SerDer();
        }

        class SerDer
        implements SerializeDeserialize<V> {
            SerDer() {
            }

            @Override
            public @NonNull LoadResult<@NonNull V> deserialize(@NonNull DeserializeInput deser) {
                LoadResult<DataTree> dataTreeResult = deser.requireDataTree();
                if (dataTreeResult.isFailure()) {
                    return LoadResult.failure(dataTreeResult.getErrorContexts());
                }
                DataTree dataTree = dataTreeResult.getOrThrow();
                return SectionAgent.this.configuration.readFrom(dataTree, deser);
            }

            @Override
            public @NonNull LoadResult<@NonNull V> deserializeUpdate(final @NonNull DeserializeInput deser, final @NonNull SerializeOutput updateTo) {
                LoadResult<DataTree> requireDataTree = deser.requireDataTree();
                if (requireDataTree.isFailure()) {
                    return LoadResult.failure(requireDataTree.getErrorContexts());
                }
                DataTree.Mut updatableTree = requireDataTree.getOrThrow().intoMut();
                class RecordUpdates {
                    private boolean updated;

                    RecordUpdates() {
                    }
                }
                final RecordUpdates recordUpdates = new RecordUpdates();
                LoadResult result = SectionAgent.this.configuration.readWithUpdate(updatableTree, new ConfigurationDefinition.ReadWithUpdateOptions(){
                    {
                    }

                    @Override
                    public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                        recordUpdates.updated = true;
                        deser.notifyUpdate(entryPath, updateReason);
                    }

                    @Override
                    public @NonNull KeyMapper keyMapper() {
                        return deser.keyMapper();
                    }

                    @Override
                    public @NonNull KeyPath keyPath() {
                        return deser.keyPath();
                    }

                    @Override
                    public int maximumErrorCollect() {
                        return deser.maximumErrorCollect();
                    }

                    @Override
                    public boolean writeEntryComments(@NonNull CommentLocation location) {
                        return updateTo.writeEntryComments(location);
                    }
                });
                if (result.isSuccess() && recordUpdates.updated) {
                    updateTo.outDataTree(updatableTree);
                }
                return result;
            }

            @Override
            public void serialize(@NonNull V value, final @NonNull SerializeOutput ser) {
                DataTree.Mut dataTreeMut = new DataTree.Mut();
                SectionAgent.this.configuration.writeTo(value, dataTreeMut, new ConfigurationDefinition.WriteOptions(){

                    @Override
                    public @NonNull KeyMapper keyMapper() {
                        return ser.keyMapper();
                    }

                    @Override
                    public boolean writeEntryComments(@NonNull CommentLocation location) {
                        return ser.writeEntryComments(location);
                    }
                });
                ser.outDataTree(dataTreeMut);
            }
        }
    }
}

