/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StringLiaison
implements TypeLiaison {
    static final String IF_MISSING_STAND_IN = "ausutfyguhibgvftrdfyguhijnbhvgfxserrftgyuhinbgvfcrxszeretfygubna";

    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        return TypeLiaison.Agent.matchOnToken(typeToken, String.class, () -> new StringAgent());
    }

    private static final class StringAgent
    implements TypeLiaison.Agent<String> {
        private StringAgent() {
        }

        @Override
        @SideEffectFree
        public @Nullable DefaultValues<String> loadDefaultValues(@NonNull TypeLiaison.DefaultInit<String> defaultInit) {
            StringDefault stringDefault = defaultInit.methodAnnotations().getAnnotation(StringDefault.class);
            if (stringDefault != null) {
                final String defaultValue = stringDefault.value();
                final String ifMissing = stringDefault.ifMissing();
                if (ifMissing.equals(StringLiaison.IF_MISSING_STAND_IN)) {
                    return DefaultValues.simple(defaultValue);
                }
                return new DefaultValues<String>(){

                    @Override
                    public @NonNull String defaultValue() {
                        return defaultValue;
                    }

                    @Override
                    public @NonNull String ifMissing() {
                        return ifMissing;
                    }
                };
            }
            return defaultInit.methodDefault();
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<String> makeSerializer() {
            return new SerializeDeserialize<String>(){

                @Override
                public @NonNull LoadResult<@NonNull String> deserialize(@NonNull DeserializeInput deser) {
                    return deser.requireString();
                }

                @Override
                public void serialize(@NonNull String value, @NonNull SerializeOutput ser) {
                    ser.outString(value);
                }
            };
        }
    }
}

