/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ClipOnSer;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.TrimOnDeser;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class SetLiaisonTest {
    @Test
    public void loadRegular(@Mock UpdateListener updateListener) {
        DataTree.Mut dataTree = new DataTree.Mut();
        DataList.Mut dataList = new DataList.Mut();
        dataList.add(new DataEntry("friends"));
        dataList.add(new DataEntry("are"));
        dataList.add(new DataEntry("good"));
        dataTree.put("values", new DataEntry(dataList));
        Configuration<Config<String>> configuration = StringType.configuration(new TypeToken<Config<String>>(this){});
        Set<String> loaded = configuration.readFrom((DataTree)dataTree, updateListener).getOrThrow().values();
        Assertions.assertEquals(Set.of("friends", "are", "good"), loaded);
        Mockito.verifyNoInteractions((Object[])new Object[]{updateListener});
    }

    @Test
    public void loadDuplicatesFromInput(@Mock UpdateListener updateListener) {
        DataTree.Mut dataTree = new DataTree.Mut();
        DataList.Mut dataList = new DataList.Mut();
        dataList.add(new DataEntry("whitespace"));
        dataList.add(new DataEntry("whitespace"));
        dataList.add(new DataEntry("is    "));
        dataList.add(new DataEntry("    bad "));
        dataTree.put("values", new DataEntry(dataList));
        Configuration<Config<TrimOnDeser>> configuration = StringType.configuration(new TypeToken<Config<TrimOnDeser>>(this){});
        Set<TrimOnDeser> loaded = configuration.readFrom((DataTree)dataTree, updateListener).getOrThrow().values();
        Assertions.assertEquals(Set.of(new TrimOnDeser("whitespace"), new TrimOnDeser("is"), new TrimOnDeser("bad")), loaded);
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Immut("values"), UpdateReason.OTHER);
    }

    @Test
    public void loadDuplicatesOnDeser(@Mock UpdateListener updateListener) {
        DataTree.Mut dataTree = new DataTree.Mut();
        DataList.Mut dataList = new DataList.Mut();
        dataList.add(new DataEntry("whitespace"));
        dataList.add(new DataEntry("is    "));
        dataList.add(new DataEntry("bad"));
        dataList.add(new DataEntry("    bad "));
        dataTree.put("values", new DataEntry(dataList));
        Configuration<Config<TrimOnDeser>> configuration = StringType.configuration(new TypeToken<Config<TrimOnDeser>>(this){});
        Set<TrimOnDeser> loaded = configuration.readFrom((DataTree)dataTree, updateListener).getOrThrow().values();
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Immut("values"), UpdateReason.OTHER);
        Assertions.assertEquals(Set.of(new TrimOnDeser("whitespace"), new TrimOnDeser("is"), new TrimOnDeser("bad")), loaded);
    }

    @Test
    public void serDuplicates() {
        Config config = () -> {
            LinkedHashSet<ClipOnSer> set = new LinkedHashSet<ClipOnSer>();
            set.add(new ClipOnSer("parts"));
            set.add(new ClipOnSer("par"));
            set.add(new ClipOnSer("pa"));
            return set;
        };
        DataTree.Mut dataTree = new DataTree.Mut();
        StringType.configuration(new TypeToken<Config<ClipOnSer>>(this){}).writeTo(config, dataTree);
        DataEntry dataEntry = dataTree.get("values");
        Assumptions.assumeTrue((dataEntry != null && dataEntry.getValue() instanceof DataList ? 1 : 0) != 0);
        DataList dataList = (DataList)dataEntry.getValue();
        Assertions.assertEquals((int)3, (int)dataList.size());
        Assertions.assertEquals((Object)"par", (Object)dataList.get(0).getValue());
        Assertions.assertEquals((Object)"par", (Object)dataList.get(1).getValue());
        Assertions.assertEquals((Object)"pa", (Object)dataList.get(2).getValue());
    }

    static interface Config<V> {
        public Set<V> values();
    }
}

