/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ByteDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.DoubleDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.FloatDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.LongDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ShortDefault;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumbersTest {
    @Test
    public void loadDefaults() {
        Config defaults = (Config)Configuration.defaultBuilder(Config.class).build().loadDefaults();
        Assertions.assertEquals((int)1, (int)defaults.byteValue());
        Assertions.assertEquals((int)2, (int)defaults.shortValue());
        Assertions.assertEquals((int)3, (int)defaults.intValue());
        Assertions.assertEquals((long)4L, (long)defaults.longValue());
        Assertions.assertEquals((double)5.0, (double)defaults.floatValue());
        Assertions.assertEquals((double)6.0, (double)defaults.doubleValue());
    }

    @Test
    public void loadDefaultsMissingValues() {
        Config defaultsIfMissing = Configuration.defaultBuilder(Config.class).build().readFrom(new DataTree.Immut()).getOrThrow();
        Assertions.assertEquals((int)1, (int)defaultsIfMissing.byteValue());
        Assertions.assertEquals((int)2, (int)defaultsIfMissing.shortValue());
        Assertions.assertEquals((int)3, (int)defaultsIfMissing.intValue());
        Assertions.assertEquals((long)4L, (long)defaultsIfMissing.longValue());
        Assertions.assertEquals((double)5.0, (double)defaultsIfMissing.floatValue());
        Assertions.assertEquals((double)6.0, (double)defaultsIfMissing.doubleValue());
    }

    @Test
    public void loadDefaultsAnnotated() {
        AnnotatedDefaults defaults = (AnnotatedDefaults)Configuration.defaultBuilder(AnnotatedDefaults.class).build().loadDefaults();
        Assertions.assertEquals((int)1, (int)defaults.byteValue());
        Assertions.assertEquals((int)2, (int)defaults.shortValue());
        Assertions.assertEquals((int)3, (int)defaults.intValue());
        Assertions.assertEquals((long)4L, (long)defaults.longValue());
        Assertions.assertEquals((double)5.0, (double)defaults.floatValue());
        Assertions.assertEquals((double)6.0, (double)defaults.doubleValue());
    }

    @Test
    public void loadDefaultsMissingValuesAnnotated() {
        AnnotatedDefaults defaultsIfMissing = Configuration.defaultBuilder(AnnotatedDefaults.class).build().readFrom(new DataTree.Immut()).getOrThrow();
        Assertions.assertEquals((int)-1, (int)defaultsIfMissing.byteValue());
        Assertions.assertEquals((int)-2, (int)defaultsIfMissing.shortValue());
        Assertions.assertEquals((int)-3, (int)defaultsIfMissing.intValue());
        Assertions.assertEquals((long)-4L, (long)defaultsIfMissing.longValue());
        Assertions.assertEquals((double)-5.0, (double)defaultsIfMissing.floatValue());
        Assertions.assertEquals((double)-6.0, (double)defaultsIfMissing.doubleValue());
    }

    private static interface Config {
        default public byte byteValue() {
            return 1;
        }

        default public short shortValue() {
            return 2;
        }

        default public int intValue() {
            return 3;
        }

        default public long longValue() {
            return 4L;
        }

        default public float floatValue() {
            return 5.0f;
        }

        default public double doubleValue() {
            return 6.0;
        }
    }

    public static interface AnnotatedDefaults {
        @ByteDefault(value=1, ifMissing=-1)
        public byte byteValue();

        @ShortDefault(value=2, ifMissing=-2)
        public short shortValue();

        @IntegerDefault(value=3, ifMissing=-3)
        public int intValue();

        @LongDefault(value=4L, ifMissing=-4L)
        public long longValue();

        @FloatDefault(value=5.0f, ifMissing=-5.0f)
        public float floatValue();

        @DoubleDefault(value=6.0, ifMissing=-6.0)
        public double doubleValue();
    }
}

