/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ClipOnSer;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.TrimOnDeser;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class MapLiaisonTest {
    @Test
    public void loadRegular(@Mock UpdateListener updateListener) {
        DataTree.Mut dataTree = new DataTree.Mut();
        DataTree.Mut innerTree = new DataTree.Mut();
        innerTree.put("friends", new DataEntry("3"));
        innerTree.put("are  ", new DataEntry(3));
        innerTree.put("good", new DataEntry("3"));
        dataTree.put("values", new DataEntry(innerTree));
        Map<Object, Integer> values = StringType.configuration(new TypeToken<Config<String, Integer>>(this){}).readFrom(dataTree).getOrThrow().values();
        Assertions.assertEquals((int)3, (int)values.size());
        values = StringType.configuration(new TypeToken<Config<TrimOnDeser, Integer>>(this){}).readFrom((DataTree)dataTree, updateListener).getOrThrow().values();
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertEquals(Map.of(new TrimOnDeser("friends"), 3, new TrimOnDeser("are"), 3, new TrimOnDeser("good"), 3), values);
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Immut("values", "friends"), UpdateReason.UPDATED);
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Immut("values", "good"), UpdateReason.UPDATED);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
    }

    @Test
    public void deserDuplicates(@Mock UpdateListener updateListener) {
        DataTree.Mut dataTree = new DataTree.Mut();
        DataTree.Mut innerTree = new DataTree.Mut();
        innerTree.put("whitespace", new DataEntry("intro"));
        innerTree.put("is", new DataEntry("hi"));
        innerTree.put("     bad ", new DataEntry("3"));
        innerTree.put("bad", new DataEntry("3"));
        dataTree.put("values", new DataEntry(innerTree));
        Map<TrimOnDeser, String> values = StringType.configuration(new TypeToken<Config<TrimOnDeser, String>>(this){}).readFrom((DataTree)dataTree, updateListener).getOrThrow().values();
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertEquals(Map.of(new TrimOnDeser("whitespace"), "intro", new TrimOnDeser("is"), "hi", new TrimOnDeser("bad"), "3"), values);
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Immut("values"), UpdateReason.OTHER);
    }

    @Test
    public void serDuplicates() {
        Config okay = () -> Map.of(new ClipOnSer("parts"), 2, new ClipOnSer("pa"), 1);
        Config withDuplicates = () -> Map.of(new ClipOnSer("parts"), 2, new ClipOnSer("par"), 2, new ClipOnSer("pa"), 1);
        Configuration<Config<ClipOnSer, Integer>> definition = StringType.configuration(new TypeToken<Config<ClipOnSer, Integer>>(this){});
        Assertions.assertDoesNotThrow(() -> definition.writeTo(okay, new DataTree.Mut()));
        Assertions.assertThrows(DeveloperMistakeException.class, () -> definition.writeTo(withDuplicates, new DataTree.Mut()));
    }

    static interface Config<K, V> {
        public Map<K, V> values();
    }
}

