/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class MapLiaison
implements TypeLiaison {
    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        if (typeToken.getRawType().equals(Map.class)) {
            AgentImpl agentImpl;
            ReifiedType.Annotated reifiedType = typeToken.getReifiedType();
            TypeToken keyToken = new TypeToken(reifiedType.argumentAt(0));
            TypeToken valueToken = new TypeToken(reifiedType.argumentAt(1));
            AgentImpl castAgent = agentImpl = new AgentImpl(handshake.getOtherSerializer(keyToken), handshake.getOtherSerializer(valueToken));
            return castAgent;
        }
        return null;
    }

    private static final class AgentImpl<K, V>
    implements TypeLiaison.Agent<Map<K, V>>,
    SerializeDeserialize<Map<K, V>> {
        private final SerializeDeserialize<K> keySerializer;
        private final SerializeDeserialize<V> valueSerializer;

        private AgentImpl(SerializeDeserialize<K> keySerializer, SerializeDeserialize<V> valueSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public @NonNull SerializeDeserialize<Map<K, V>> makeSerializer() {
            return this;
        }

        private <D extends DataTree> @NonNull LoadResult<@NonNull Map<K, V>> implDeserialize(@NonNull DeserializeInput deser, @NonNull ImplDeserialize<D, K, V> implDeserialize) {
            LoadResult<DataTree> dataTreeResult = deser.requireDataTree();
            if (dataTreeResult.isFailure()) {
                return LoadResult.failure(dataTreeResult.getErrorContexts());
            }
            D input = implDeserialize.prepare(dataTreeResult.getOrThrow());
            ErrorContext[] collectedErrors = null;
            int errorCount = 0;
            LinkedHashMap<K, V> built = new LinkedHashMap<K, V>();
            for (Object inputKey : ((DataTree)input).keySet()) {
                DataEntry inputEntry = ((DataTree)input).get(inputKey);
                if (inputEntry == null) {
                    throw new IllegalStateException("Key " + inputKey + " is part of keySet() but not in the data tree itself");
                }
                LoadResult<K> keyResult = implDeserialize.deserialize(this.keySerializer, deser.makeChild(inputEntry.withValue(inputKey), inputKey));
                if (keyResult.isFailure()) {
                    if (collectedErrors == null) {
                        collectedErrors = new ErrorContext[deser.maximumErrorCollect()];
                    }
                    for (ErrorContext errorToAppend : keyResult.getErrorContexts()) {
                        collectedErrors[errorCount++] = errorToAppend;
                        if (errorCount != collectedErrors.length) continue;
                        return LoadResult.failure(collectedErrors);
                    }
                    continue;
                }
                K key = keyResult.getOrThrow();
                Object keyUpdate = implDeserialize.getUpdateFromDeserializeCall();
                LoadResult<V> valueResult = implDeserialize.deserialize(this.valueSerializer, deser.makeChild(inputEntry, inputKey));
                if (valueResult.isFailure()) {
                    if (collectedErrors == null) {
                        collectedErrors = new ErrorContext[deser.maximumErrorCollect()];
                    }
                    for (ErrorContext errorToAppend : keyResult.getErrorContexts()) {
                        collectedErrors[errorCount++] = errorToAppend;
                        if (errorCount != collectedErrors.length) continue;
                        return LoadResult.failure(collectedErrors);
                    }
                    continue;
                }
                V value = valueResult.getOrThrow();
                Object valueUpdate = implDeserialize.getUpdateFromDeserializeCall();
                implDeserialize.updateIfDesired(input, inputKey, inputEntry, keyUpdate, valueUpdate);
                built.put(key, value);
            }
            if (collectedErrors != null) {
                return LoadResult.failure((ErrorContext[])Arrays.copyOf(collectedErrors, errorCount));
            }
            if (((DataTree)input).size() != built.size()) {
                implDeserialize.updateSizeShrunk(deser, built);
            } else {
                implDeserialize.updateMaybeOtherwise(deser, input);
            }
            return LoadResult.of(Collections.unmodifiableMap(built));
        }

        @Override
        public @NonNull LoadResult<@NonNull Map<K, V>> deserialize(@NonNull DeserializeInput deser) {
            return this.implDeserialize(deser, new ImplDeserialize<DataTree, K, V>(){

                @Override
                public DataTree prepare(DataTree dataTree) {
                    return dataTree;
                }

                @Override
                public <E> LoadResult<E> deserialize(SerializeDeserialize<E> serializer, DeserializeInput deser) {
                    return serializer.deserialize(deser);
                }

                @Override
                public @Nullable Object getUpdateFromDeserializeCall() {
                    return null;
                }

                @Override
                public void updateIfDesired(DataTree updatableInput, Object inputKey, DataEntry inputEntry, @Nullable Object keyUpdate, @Nullable Object valueUpdate) {
                }

                @Override
                public void updateSizeShrunk(DeserializeInput deser, Map<K, V> built) {
                    deser.notifyUpdate(KeyPath.empty(), UpdateReason.OTHER);
                }

                @Override
                public void updateMaybeOtherwise(DeserializeInput deser, DataTree updatableInput) {
                }
            });
        }

        @Override
        public @NonNull LoadResult<@NonNull Map<K, V>> deserializeUpdate(@NonNull DeserializeInput deser, final @NonNull SerializeOutput updateTo) {
            return this.implDeserialize(deser, new ImplDeserialize<DataTree.Mut, K, V>(){
                private boolean updated;

                @Override
                public DataTree.Mut prepare(DataTree dataTree) {
                    return dataTree.intoMut();
                }

                @Override
                public <E> LoadResult<E> deserialize(SerializeDeserialize<E> serializer, DeserializeInput deser) {
                    return serializer.deserializeUpdate(deser, updateTo);
                }

                @Override
                public @Nullable Object getUpdateFromDeserializeCall() {
                    return updateTo.getAndClearLastOutput();
                }

                @Override
                public void updateIfDesired(DataTree.Mut updatableInput, Object inputKey, DataEntry inputEntry, @Nullable Object keyUpdate, @Nullable Object valueUpdate) {
                    boolean updateValue;
                    boolean updateKey = keyUpdate != null && !inputKey.equals(keyUpdate);
                    boolean bl = updateValue = valueUpdate != null && !inputEntry.getValue().equals(valueUpdate);
                    if (updateKey || updateValue) {
                        DataEntry entry = updateValue ? inputEntry.withValue(valueUpdate) : inputEntry;
                        if (updateKey) {
                            updatableInput.remove(inputKey);
                            updatableInput.put(keyUpdate, entry);
                        } else {
                            updatableInput.put(inputKey, entry);
                        }
                        this.updated = true;
                    }
                }

                @Override
                public void updateSizeShrunk(DeserializeInput deser, Map<K, V> built) {
                    deser.notifyUpdate(KeyPath.empty(), UpdateReason.OTHER);
                    this.serialize(built, updateTo);
                }

                @Override
                public void updateMaybeOtherwise(DeserializeInput deser, DataTree.Mut updatableInput) {
                    if (this.updated) {
                        deser.notifyUpdate(KeyPath.empty(), UpdateReason.UPDATED);
                        updateTo.outDataTree(updatableInput);
                    }
                }
            });
        }

        @Override
        public void serialize(@NonNull Map<K, V> value, @NonNull SerializeOutput ser) {
            DataTree.Mut output = new DataTree.Mut();
            for (Map.Entry<K, V> entry : value.entrySet()) {
                this.keySerializer.serialize(entry.getKey(), ser);
                Object keyOutput = ser.getAndClearLastOutput();
                if (keyOutput == null) {
                    throw new DeveloperMistakeException("Key serializer " + this.keySerializer + " did not produce output");
                }
                this.valueSerializer.serialize(entry.getValue(), ser);
                Object valueOutput = ser.getAndClearLastOutput();
                if (valueOutput == null) {
                    throw new DeveloperMistakeException("Value serializer " + this.valueSerializer + " did not produce output");
                }
                DataEntry previousValue = output.put(keyOutput, new DataEntry(valueOutput));
                if (previousValue == null) continue;
                throw new DeveloperMistakeException("The key serializer " + this.keySerializer + " produced a duplicate output key " + keyOutput);
            }
            ser.outDataTree(output);
        }

        static interface ImplDeserialize<D extends DataTree, K, V> {
            public D prepare(DataTree var1);

            public <E> LoadResult<E> deserialize(SerializeDeserialize<E> var1, DeserializeInput var2);

            public @Nullable Object getUpdateFromDeserializeCall();

            public void updateIfDesired(D var1, Object var2, DataEntry var3, @Nullable Object var4, @Nullable Object var5);

            public void updateSizeShrunk(DeserializeInput var1, Map<K, V> var2);

            public void updateMaybeOtherwise(DeserializeInput var1, D var2);
        }
    }
}

