/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.BaseNumberLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerRange;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IntegerLiaison
extends BaseNumberLiaison<Integer, IntegerDefault, IntegerRange> {
    @Override
    @NonNull Class<Integer> boxedType() {
        return Integer.class;
    }

    @Override
    @NonNull Class<Integer> primitiveType() {
        return Integer.TYPE;
    }

    @Override
    @NonNull Class<IntegerDefault> defaultAnnotation() {
        return IntegerDefault.class;
    }

    @Override
    @NonNull Integer defaultValue(@NonNull IntegerDefault defaultAnnotation) {
        return defaultAnnotation.value();
    }

    @Override
    @NonNull Integer ifMissing(@NonNull IntegerDefault defaultAnnotation) {
        return defaultAnnotation.ifMissing();
    }

    @Override
    @Nullable Integer castNumbers(@NonNull Object input) {
        long longValue;
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Short) {
            return (int)((Short)input);
        }
        if (input instanceof Byte) {
            return (int)((Byte)input);
        }
        if (input instanceof Long && (long)((int)(longValue = ((Long)input).longValue())) == longValue) {
            return (int)longValue;
        }
        return null;
    }

    @Override
    @Nullable Integer parseFrom(@NonNull String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @NonNull Class<IntegerRange> rangeAnnotation() {
        return IntegerRange.class;
    }

    @Override
    @NonNull Integer minFrom(@NonNull IntegerRange integerRange) {
        return integerRange.min();
    }

    @Override
    @NonNull Integer maxFrom(@NonNull IntegerRange integerRange) {
        return integerRange.max();
    }

    @Override
    boolean greaterOrEq(@NonNull Integer value, @NonNull Integer min) {
        return value >= min;
    }

    @Override
    boolean lessOrEq(@NonNull Integer value, @NonNull Integer max) {
        return value <= max;
    }
}

